/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.annotation.IgnoreCloak;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.BasicRule;
import com.flipkart.masquerade.rule.CompositeRule;
import com.flipkart.masquerade.rule.Conjunction;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.rule.ValueRule;
import com.flipkart.masquerade.serialization.FieldMeta;
import com.flipkart.masquerade.util.EntryType;
import com.flipkart.masquerade.util.FieldDescriptor;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.RepositoryEntry;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class OverrideProcessor
extends BaseOverrideProcessor {
    public OverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public Optional<TypeSpec> createOverride(Rule rule, Class<?> clazz, List<RepositoryEntry> repositoryEntries) {
        MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, clazz);
        this.declareInitializeVariables(methodBuilder);
        List<Field> originalFields = Helper.getNonStaticFields(clazz).stream().filter(field -> !field.isAnnotationPresent(IgnoreCloak.class) && !field.isAnnotationPresent(JsonIgnore.class)).collect(Collectors.toList());
        List<FieldMeta> nonStaticFields = this.orderedFields(originalFields, clazz);
        this.addSyntheticFields(clazz, nonStaticFields);
        for (FieldMeta field2 : nonStaticFields) {
            if (this.skipProcessing(field2)) continue;
            if (field2.isSynthetic()) {
                this.handleSyntheticFields(field2, methodBuilder);
                continue;
            }
            if (!this.skipAnnotationProcessing(field2)) {
                Class<? extends Annotation> annotationClass = rule.getAnnotationClass();
                Annotation[] annotations = field2.getField().getAnnotationsByType(annotationClass);
                if (annotations != null && annotations.length != 0) {
                    ArrayList<CodeBlock> operationBlocks = new ArrayList<CodeBlock>();
                    for (Annotation annotation : annotations) {
                        operationBlocks.add(this.constructOperation(rule, annotationClass, annotation));
                    }
                    this.constructFinalOperation(methodBuilder, field2.getField(), clazz, operationBlocks);
                }
            }
            this.handleFieldKeys(clazz, field2, methodBuilder);
            this.addRecursiveStatement(rule, clazz, field2.getField(), methodBuilder, repositoryEntries);
            this.handleFieldValues(field2, methodBuilder);
        }
        this.returns(methodBuilder);
        MethodSpec methodSpec = methodBuilder.build();
        if (methodSpec.code.isEmpty()) {
            this.addNoOpInitializerCode(rule, clazz, repositoryEntries);
            return Optional.empty();
        }
        this.addInitializerCode(rule, clazz, repositoryEntries);
        String implName = Helper.getImplementationName(rule, clazz);
        return Optional.ofNullable(this.generateImplementationType(rule, clazz, implName, methodSpec));
    }

    private void addRecursiveStatement(Rule rule, Class<?> clazz, Field field, MethodSpec.Builder methodBuilder, List<RepositoryEntry> repositoryEntries) {
        if (!this.skipRecursiveCall(field)) {
            String getter = Helper.getGetterName(field.getName(), Helper.isBoolean(field.getType()), field.getType().isPrimitive());
            try {
                clazz.getMethod(getter, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("A cloak-able class should have a getter defined for all fields. Class: " + clazz.getName() + " Field: " + field.getName());
            }
            if (field.getType().isEnum()) {
                this.addEnumInitializerCode(rule, field.getType(), repositoryEntries);
            }
            this.recursiveStatement(rule, methodBuilder, field.getType(), getter);
        }
    }

    private void addNoOpInitializerCode(Rule rule, Class<?> clazz, List<RepositoryEntry> repositoryEntries) {
        repositoryEntries.add(new RepositoryEntry(rule, clazz, EntryType.NoOP));
    }

    private void addEnumInitializerCode(Rule rule, Class<?> clazz, List<RepositoryEntry> repositoryEntries) {
        repositoryEntries.add(new RepositoryEntry(rule, clazz, EntryType.ENUM));
    }

    private void addInitializerCode(Rule rule, Class<?> clazz, List<RepositoryEntry> repositoryEntries) {
        repositoryEntries.add(new RepositoryEntry(rule, clazz, EntryType.NEW));
    }

    private CodeBlock constructOperation(Rule rule, Class<? extends Annotation> annotationClass, Annotation annotation) {
        ArrayList<Object> operands = new ArrayList<Object>();
        CompositeRule baseRule = rule.getValueRule();
        String operation = this.constructBasicOperation(baseRule, baseRule.getConjunction(), annotationClass, annotation, operands);
        return CodeBlock.of((String)operation, (Object[])operands.toArray());
    }

    private void constructFinalOperation(MethodSpec.Builder builder, Field field, Class<?> clazz, List<CodeBlock> operationBlocks) {
        String setter = Helper.getSetterName(field.getName(), Helper.isBoolean(field.getType()));
        try {
            clazz.getMethod(setter, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("A cloak-able class should have a setter defined for all fields. Class: " + clazz.getName() + " Field: " + field.getName());
        }
        StringBuilder operationBuilder = new StringBuilder();
        for (int i = 0; i < operationBlocks.size(); ++i) {
            operationBuilder.append("($L)");
            if (i == operationBlocks.size() - 1) continue;
            operationBuilder.append(" || ");
        }
        builder.beginControlFlow("if (" + operationBuilder.toString() + ")", operationBlocks.toArray());
        builder.addStatement("$L.$L(null)", new Object[]{Strings.OBJECT_PARAMETER, setter});
        builder.endControlFlow();
    }

    private String constructBasicOperation(CompositeRule compositeRule, Conjunction conjunction, Class<? extends Annotation> annotationClass, Annotation annotation, List<Object> operands) {
        StringBuilder operation = new StringBuilder();
        for (ValueRule valueRule : compositeRule.getValueRules()) {
            Object defaultValue;
            Object value;
            if (valueRule instanceof CompositeRule) {
                CompositeRule innerRule = (CompositeRule)valueRule;
                String constructedCompositeOperation = this.constructBasicOperation(innerRule, innerRule.getConjunction(), annotationClass, annotation, operands);
                if (constructedCompositeOperation.length() == 0) continue;
                operation.append("(").append(constructedCompositeOperation).append(")").append(" ").append(conjunction.getSymbol()).append(" ");
                continue;
            }
            BasicRule basicRule = (BasicRule)valueRule;
            try {
                Method annotationValue = annotationClass.getDeclaredMethod(basicRule.getAnnotationMember(), new Class[0]);
                value = annotationValue.invoke((Object)annotation, new Object[0]);
                defaultValue = annotationValue.getDefaultValue();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Please provide a annotation member that exists");
            }
            if (basicRule.isDefaultIgnored() && value.equals(defaultValue)) continue;
            FieldDescriptor descriptor = this.generateDescriptor(value);
            basicRule.getOperator().getGenerateOperation().accept(operation, descriptor);
            operation.append(" ").append(conjunction.getSymbol()).append(" ");
            String evalFunc = Helper.getEvaluationFunction(basicRule);
            value = this.handleEnum(descriptor, value);
            operands.add(evalFunc);
            operands.add(value);
        }
        return operation.length() < 4 ? operation.toString() : operation.delete(operation.length() - 4, operation.length()).toString();
    }

    private FieldDescriptor generateDescriptor(Object value) {
        boolean isPrimitive = value.getClass().isPrimitive() || Helper.getWrapperTypes().contains(value.getClass());
        return new FieldDescriptor(isPrimitive, isPrimitive || value.getClass().isEnum(), isPrimitive || Comparable.class.isAssignableFrom(value.getClass()), value.getClass().isEnum());
    }

    private Object handleEnum(FieldDescriptor descriptor, Object value) {
        if (!descriptor.isEnumeration()) {
            return value;
        }
        ClassName enumName = ClassName.get((String)value.getClass().getPackage().getName(), (String)value.getClass().getSimpleName(), (String[])new String[0]);
        return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{enumName, value});
    }

    private List<FieldMeta> orderedFields(List<Field> fields, Class<?> clazz) {
        List<FieldMeta> fieldMetas = this.transform(fields, clazz);
        return this.enrichFieldMetas(fieldMetas, clazz);
    }

    private List<FieldMeta> transform(List<Field> fields, Class<?> clazz) {
        return fields.stream().map(field -> new FieldMeta((Field)field, clazz)).collect(Collectors.toList());
    }

    protected abstract void declareInitializeVariables(MethodSpec.Builder var1);

    protected abstract List<FieldMeta> enrichFieldMetas(List<FieldMeta> var1, Class<?> var2);

    protected abstract void addSyntheticFields(Class<?> var1, List<FieldMeta> var2);

    protected abstract boolean skipProcessing(FieldMeta var1);

    protected abstract void handleSyntheticFields(FieldMeta var1, MethodSpec.Builder var2);

    protected abstract boolean skipAnnotationProcessing(FieldMeta var1);

    protected abstract void handleFieldKeys(Class<?> var1, FieldMeta var2, MethodSpec.Builder var3);

    protected abstract void handleFieldValues(FieldMeta var1, MethodSpec.Builder var2);

    protected abstract void returns(MethodSpec.Builder var1);

    protected abstract boolean skipRecursiveCall(Field var1);

    protected abstract void recursiveStatement(Rule var1, MethodSpec.Builder var2, Class<?> var3, String var4);
}

