/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.DebugProcessor;
import com.flipkart.masquerade.processor.DefaultOverrideProcessor;
import com.flipkart.masquerade.processor.OverrideProcessor;
import com.flipkart.masquerade.processor.RepositoryProcessor;
import com.flipkart.masquerade.processor.RuleProcessor;
import com.flipkart.masquerade.processor.SerializationOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.RepositoryEntry;
import com.flipkart.masquerade.util.TypeSpecContainer;
import com.google.common.reflect.ClassPath;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;

public class Masquerade {
    private static final List<TypeSpecContainer> specs = new ArrayList<TypeSpecContainer>();

    public static void initialize(Configuration configuration, File destination) throws IOException, ClassNotFoundException {
        Masquerade.initialize(configuration, ClassLoader.getSystemClassLoader(), destination);
    }

    public static void initialize(Configuration configuration, ClassLoader classLoader, File destination) throws IOException, ClassNotFoundException {
        if (configuration == null || classLoader == null || destination == null) {
            throw new NullPointerException("Masquerade does not accept any null parameters");
        }
        if (configuration.getRules() == null || configuration.getCloakPackage() == null || configuration.getPackagesToScan() == null) {
            throw new NullPointerException("Configuration cannot return any null objects");
        }
        Set<ClassPath.ClassInfo> scannedClasses = Helper.getPackageClasses(classLoader, configuration.getPackagesToScan());
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Cloak");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        RuleProcessor ruleProcessor = new RuleProcessor(configuration, builder);
        OverrideProcessor overrideProcessor = configuration.isNativeSerializationEnabled() ? new SerializationOverrideProcessor(configuration, builder) : new DefaultOverrideProcessor(configuration, builder);
        RepositoryProcessor repositoryProcessor = new RepositoryProcessor(configuration, builder);
        repositoryProcessor.createReference();
        DebugProcessor debugProcessor = new DebugProcessor(configuration, builder);
        debugProcessor.addGetter();
        specs.addAll(ruleProcessor.generateRuleTypeSpecs());
        ArrayList<RepositoryEntry> repositoryEntries = new ArrayList<RepositoryEntry>();
        Helper.mapClasses(scannedClasses, classLoader);
        for (Class<?> clazz : Helper.getClasses()) {
            if (clazz.isEnum() || clazz.isInterface() || Helper.getClassInformation(clazz).isAbstract() || !Helper.getClassInformation(clazz).isPublic()) continue;
            for (Rule rule : configuration.getRules()) {
                overrideProcessor.createOverride(rule, clazz, repositoryEntries).ifPresent(typeSpec -> specs.add(new TypeSpecContainer(Helper.getImplementationPackage(configuration, clazz), (TypeSpec)typeSpec)));
            }
        }
        specs.add(new TypeSpecContainer(configuration.getCloakPackage(), builder.build()));
        specs.add(new TypeSpecContainer(configuration.getCloakPackage(), repositoryProcessor.createRepository(repositoryEntries)));
        for (TypeSpecContainer container : specs) {
            TypeSpec.Builder typeBuilder = container.getSpec().toBuilder().addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"com.flipkart.masquerade.Masquerade"}).build());
            JavaFile javaFile = JavaFile.builder((String)container.getPackagePath(), (TypeSpec)typeBuilder.build()).indent("    ").skipJavaLangImports(true).build();
            javaFile.writeTo(destination);
        }
    }
}

