/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.DebugProcessor;
import com.flipkart.masquerade.processor.FallbackProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class RuleObjectProcessor {
    private final Configuration configuration;
    private final TypeSpec.Builder cloakBuilder;
    private final DebugProcessor debugProcessor;
    private final FallbackProcessor fallbackProcessor;

    public RuleObjectProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
        this.debugProcessor = new DebugProcessor(configuration, cloakBuilder);
        this.fallbackProcessor = new FallbackProcessor(configuration, cloakBuilder);
    }

    public void addEntry(Rule rule) {
        MethodSpec.Builder objectMaskBuilder = MethodSpec.methodBuilder((String)"hide");
        objectMaskBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        objectMaskBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build());
        objectMaskBuilder.addParameter(Object.class, Strings.OBJECT_PARAMETER, new Modifier[0]);
        objectMaskBuilder.addParameter(rule.getEvaluatorClass(), "eval", new Modifier[0]);
        objectMaskBuilder.beginControlFlow("if ($L == null)", new Object[]{Strings.OBJECT_PARAMETER});
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.addStatement("return null", new Object[0]);
        } else {
            objectMaskBuilder.addStatement("return", new Object[0]);
        }
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.addStatement("$T $L = this.$L.get($L.getClass().getName())", new Object[]{Helper.getRuleInterface(this.configuration, rule), "masker", rule.getName(), Strings.OBJECT_PARAMETER});
        objectMaskBuilder.beginControlFlow("if ($L != null)", new Object[]{"masker"});
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.addStatement("return $L.$L($L, $L, this)", new Object[]{"masker", Strings.INTERFACE_METHOD, Strings.OBJECT_PARAMETER, "eval"});
        } else {
            objectMaskBuilder.addStatement("$L.$L($L, $L, this)", new Object[]{"masker", Strings.INTERFACE_METHOD, Strings.OBJECT_PARAMETER, "eval"});
        }
        objectMaskBuilder.nextControlFlow("else", new Object[0]);
        objectMaskBuilder.beginControlFlow("if ($L instanceof $T)", new Object[]{Strings.OBJECT_PARAMETER, Map.class});
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.addStatement("$T $L = new $T($S)", new Object[]{StringBuilder.class, "serialized", StringBuilder.class, "{"});
            objectMaskBuilder.addStatement("(($T) $L).forEach((k, v) -> $L.append($S).append(k).append($S).append($S).append(this.$L(v, $L)).append($S))", new Object[]{Map.class, Strings.OBJECT_PARAMETER, "serialized", "\"", "\"", ":", "hide", "eval", ","});
            objectMaskBuilder.beginControlFlow("if ($L.length() > 1)", new Object[]{"serialized"});
            objectMaskBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
            objectMaskBuilder.endControlFlow();
            objectMaskBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "}"});
            objectMaskBuilder.addStatement("return $L.toString()", new Object[]{"serialized"});
        } else {
            objectMaskBuilder.addStatement("this.$L(((Map) $L).values(), $L)", new Object[]{"hide", Strings.OBJECT_PARAMETER, "eval"});
        }
        objectMaskBuilder.nextControlFlow("else if ($L instanceof $T)", new Object[]{Strings.OBJECT_PARAMETER, Collection.class});
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.addStatement("$T $L = new $T($S)", new Object[]{StringBuilder.class, "serialized", StringBuilder.class, "["});
        }
        objectMaskBuilder.beginControlFlow("for (Object o : ((Collection) $L))", new Object[]{Strings.OBJECT_PARAMETER});
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.addStatement("$L.append(this.$L(o, $L))", new Object[]{"serialized", "hide", "eval"});
            objectMaskBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
        } else {
            objectMaskBuilder.addStatement("this.$L(o, $L)", new Object[]{"hide", "eval"});
        }
        objectMaskBuilder.endControlFlow();
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.beginControlFlow("if ($L.length() > 1)", new Object[]{"serialized"});
            objectMaskBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
            objectMaskBuilder.endControlFlow();
            objectMaskBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "]"});
            objectMaskBuilder.addStatement("return $L.toString()", new Object[]{"serialized"});
        }
        objectMaskBuilder.nextControlFlow("else if ($L instanceof Object[])", new Object[]{Strings.OBJECT_PARAMETER});
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.addStatement("$T $L = new $T($S)", new Object[]{StringBuilder.class, "serialized", StringBuilder.class, "["});
        }
        objectMaskBuilder.beginControlFlow("for (Object o : ((Object[]) $L))", new Object[]{Strings.OBJECT_PARAMETER});
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.addStatement("$L.append(this.$L(o, $L))", new Object[]{"serialized", "hide", "eval"});
            objectMaskBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
        } else {
            objectMaskBuilder.addStatement("this.$L(o, $L)", new Object[]{"hide", "eval"});
        }
        objectMaskBuilder.endControlFlow();
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.beginControlFlow("if ($L.length() > 1)", new Object[]{"serialized"});
            objectMaskBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
            objectMaskBuilder.endControlFlow();
            objectMaskBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "]"});
            objectMaskBuilder.addStatement("return $L.toString()", new Object[]{"serialized"});
        }
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.nextControlFlow("else if ($L.getClass().isArray())", new Object[]{Strings.OBJECT_PARAMETER});
            objectMaskBuilder.beginControlFlow("if ($L instanceof $T[])", new Object[]{Strings.OBJECT_PARAMETER, Character.TYPE});
            objectMaskBuilder.addStatement("return $S + new $T(($T[]) $L) + $S", new Object[]{"\"", String.class, Character.TYPE, Strings.OBJECT_PARAMETER, "\""});
            ArrayList primitiveTypes = new ArrayList(Helper.getPrimitivesTypes());
            for (int i = 0; i < primitiveTypes.size(); ++i) {
                Class primitiveType = (Class)primitiveTypes.get(i);
                objectMaskBuilder.nextControlFlow("else if ($L instanceof $T[])", new Object[]{Strings.OBJECT_PARAMETER, primitiveType});
                objectMaskBuilder.addStatement("$T $L = new $T($S)", new Object[]{StringBuilder.class, "serialized", StringBuilder.class, "["});
                objectMaskBuilder.beginControlFlow("for ($T o : (($T[]) $L))", new Object[]{primitiveType, primitiveType, Strings.OBJECT_PARAMETER});
                objectMaskBuilder.addStatement("$L.append(this.$L(o, $L))", new Object[]{"serialized", "hide", "eval"});
                objectMaskBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
                objectMaskBuilder.endControlFlow();
                objectMaskBuilder.beginControlFlow("if ($L.length() > 1)", new Object[]{"serialized"});
                objectMaskBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
                objectMaskBuilder.endControlFlow();
                objectMaskBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "]"});
                objectMaskBuilder.addStatement("return $L.toString()", new Object[]{"serialized"});
            }
            objectMaskBuilder.endControlFlow();
        }
        this.debugProcessor.addDebugCollector(objectMaskBuilder);
        this.fallbackProcessor.addFallbackCall(objectMaskBuilder);
        objectMaskBuilder.endControlFlow();
        objectMaskBuilder.endControlFlow();
        if (this.configuration.isNativeSerializationEnabled()) {
            objectMaskBuilder.returns(String.class);
            objectMaskBuilder.addStatement("return null", new Object[0]);
        }
        this.cloakBuilder.addMethod(objectMaskBuilder.build());
    }
}

