/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.annotation.IgnoreCloak;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.BasicRule;
import com.flipkart.masquerade.rule.CompositeRule;
import com.flipkart.masquerade.rule.Conjunction;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.rule.ValueRule;
import com.flipkart.masquerade.serialization.FieldMeta;
import com.flipkart.masquerade.serialization.SerializationProperty;
import com.flipkart.masquerade.util.FieldDescriptor;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.google.common.base.Defaults;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OverrideProcessor
extends BaseOverrideProcessor {
    public OverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public Optional<TypeSpec> createOverride(Rule rule, Class<?> clazz, CodeBlock.Builder initializer) {
        MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, clazz);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.addStatement("$T $L = new $T($S)", new Object[]{StringBuilder.class, "serialized", StringBuilder.class, "{"});
        }
        List<Field> originalFields = Helper.getNonStaticFields(clazz).stream().filter(field -> !field.isAnnotationPresent(IgnoreCloak.class) && !field.isAnnotationPresent(JsonIgnore.class)).collect(Collectors.toList());
        List<FieldMeta> nonStaticFields = this.orderedFields(originalFields, clazz);
        this.addSubTypeControl(clazz, nonStaticFields);
        for (FieldMeta field2 : nonStaticFields) {
            if (field2.getType().isPrimitive() && !this.configuration.isNativeSerializationEnabled()) continue;
            if (this.configuration.isNativeSerializationEnabled() && field2.isSynthetic()) {
                methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "\"" + field2.getSerializableName() + "\"" + ":" + "\"" + field2.getSyntheticValue() + "\""});
                methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
                continue;
            }
            if (!field2.getType().isPrimitive()) {
                Class<? extends Annotation> annotationClass = rule.getAnnotationClass();
                Annotation[] annotations = field2.getField().getAnnotationsByType(annotationClass);
                if (annotations != null && annotations.length != 0) {
                    for (Annotation annotation : annotations) {
                        this.constructOperation(rule, annotationClass, annotation, methodBuilder, field2.getField(), clazz);
                    }
                }
            }
            if (this.configuration.isNativeSerializationEnabled()) {
                this.resolveInclusionLevel(clazz, field2);
                if (field2.getInclusionLevel() != JsonInclude.Include.ALWAYS) {
                    CodeBlock inclusionCondition = this.constructInclusionCondition(field2);
                    if (field2.isMaskable()) {
                        methodBuilder.beginControlFlow("$L", new Object[]{inclusionCondition});
                    }
                }
                methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "\"" + field2.getSerializableName() + "\"" + ":"});
            }
            this.addRecursiveStatement(rule, clazz, field2.getField(), methodBuilder, initializer);
            if (!this.configuration.isNativeSerializationEnabled()) continue;
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", ","});
            if (field2.getInclusionLevel() == JsonInclude.Include.ALWAYS || !field2.isMaskable()) continue;
            methodBuilder.endControlFlow();
        }
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.beginControlFlow("if ($L.length() > 1)", new Object[]{"serialized"});
            methodBuilder.addStatement("$L.deleteCharAt($L.length() - 1)", new Object[]{"serialized", "serialized"});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$L.append($S)", new Object[]{"serialized", "}"});
            methodBuilder.addStatement("return $L.toString()", new Object[]{"serialized"});
        }
        MethodSpec methodSpec = methodBuilder.build();
        if (methodSpec.code.isEmpty()) {
            this.addNoOpInitializerCode(rule, clazz, initializer);
            return Optional.empty();
        }
        String implName = Helper.getImplementationName(rule, clazz);
        this.addInitializerCode(rule, clazz, initializer, implName);
        return Optional.ofNullable(this.generateImplementationType(rule, clazz, implName, methodSpec));
    }

    private void addRecursiveStatement(Rule rule, Class<?> clazz, Field field, MethodSpec.Builder methodBuilder, CodeBlock.Builder initializer) {
        if (!field.getType().isPrimitive() && !Helper.getWrapperTypes().contains(field.getType()) && !String.class.isAssignableFrom(field.getType()) && !field.getType().isEnum() || this.configuration.isNativeSerializationEnabled()) {
            String getter = Helper.getGetterName(field.getName(), Helper.isBoolean(field.getType()), field.getType().isPrimitive());
            try {
                clazz.getMethod(getter, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("A cloak-able class should have a getter defined for all fields. Class: " + clazz.getName() + " Field: " + field.getName());
            }
            if (field.getType().isEnum()) {
                this.addEnumInitializerCode(rule, field.getType(), initializer);
            }
            if (this.configuration.isNativeSerializationEnabled()) {
                methodBuilder.addStatement("$L.append($L.$L($L.$L(), $L))", new Object[]{"serialized", Strings.CLOAK_PARAMETER, "hide", Strings.OBJECT_PARAMETER, getter, "eval"});
            } else {
                methodBuilder.addStatement("$L.$L($L.$L(), $L)", new Object[]{Strings.CLOAK_PARAMETER, "hide", Strings.OBJECT_PARAMETER, getter, "eval"});
            }
        }
    }

    private void addNoOpInitializerCode(Rule rule, Class<?> clazz, CodeBlock.Builder initializer) {
        initializer.addStatement("$L.put($S, $L)", new Object[]{rule.getName(), clazz.getName(), Helper.getNoOpVariableName(rule)});
    }

    private void addEnumInitializerCode(Rule rule, Class<?> clazz, CodeBlock.Builder initializer) {
        initializer.addStatement("$L.put($S, $L)", new Object[]{rule.getName(), clazz.getName(), Helper.getEnumVariableName(rule)});
    }

    private void addInitializerCode(Rule rule, Class<?> clazz, CodeBlock.Builder initializer, String implName) {
        ClassName cloakName = ClassName.get((String)Helper.getImplementationPackage(this.configuration, clazz), (String)implName, (String[])new String[0]);
        initializer.addStatement("$L.put($S, new $T())", new Object[]{rule.getName(), clazz.getName(), cloakName});
    }

    private void constructOperation(Rule rule, Class<? extends Annotation> annotationClass, Annotation annotation, MethodSpec.Builder builder, Field field, Class<?> clazz) {
        ArrayList<Object> operands = new ArrayList<Object>();
        CompositeRule baseRule = rule.getValueRule();
        String operation = this.constructBasicOperation(baseRule, baseRule.getConjunction(), annotationClass, annotation, operands);
        String setter = Helper.getSetterName(field.getName(), Helper.isBoolean(field.getType()));
        Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(setter)).findFirst().orElseThrow(() -> new UnsupportedOperationException("A cloak-able class should have a setter defined for all fields. Class: " + clazz.getName() + " Field: " + field.getName()));
        builder.beginControlFlow("if (" + operation + ")", operands.toArray());
        builder.addStatement("$L.$L(null)", new Object[]{Strings.OBJECT_PARAMETER, setter});
        builder.endControlFlow();
    }

    private String constructBasicOperation(CompositeRule compositeRule, Conjunction conjunction, Class<? extends Annotation> annotationClass, Annotation annotation, List<Object> operands) {
        StringBuilder operation = new StringBuilder();
        for (ValueRule valueRule : compositeRule.getValueRules()) {
            Object defaultValue;
            Object value;
            if (valueRule instanceof CompositeRule) {
                CompositeRule innerRule = (CompositeRule)valueRule;
                String constructedCompositeOperation = this.constructBasicOperation(innerRule, innerRule.getConjunction(), annotationClass, annotation, operands);
                if (constructedCompositeOperation.length() == 0) continue;
                operation.append("(").append(constructedCompositeOperation).append(")").append(" ").append(conjunction.getSymbol()).append(" ");
                continue;
            }
            BasicRule basicRule = (BasicRule)valueRule;
            try {
                Method annotationValue = annotationClass.getDeclaredMethod(basicRule.getAnnotationMember(), new Class[0]);
                value = annotationValue.invoke((Object)annotation, new Object[0]);
                defaultValue = annotationValue.getDefaultValue();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Please provide a annotation member that exists");
            }
            if (basicRule.isDefaultIgnored() && value.equals(defaultValue)) continue;
            FieldDescriptor descriptor = this.generateDescriptor(value);
            basicRule.getOperator().getGenerateOperation().accept(operation, descriptor);
            operation.append(" ").append(conjunction.getSymbol()).append(" ");
            String evalFunc = Helper.getEvaluationFunction(basicRule);
            value = this.handleEnum(descriptor, value);
            operands.add(evalFunc);
            operands.add(value);
        }
        return operation.length() < 4 ? operation.toString() : operation.delete(operation.length() - 4, operation.length()).toString();
    }

    private FieldDescriptor generateDescriptor(Object value) {
        boolean isPrimitive = value.getClass().isPrimitive() || Helper.getWrapperTypes().contains(value.getClass());
        return new FieldDescriptor(isPrimitive, isPrimitive || value.getClass().isEnum(), isPrimitive || Comparable.class.isAssignableFrom(value.getClass()), value.getClass().isEnum());
    }

    private Object handleEnum(FieldDescriptor descriptor, Object value) {
        if (!descriptor.isEnumeration()) {
            return value;
        }
        ClassName enumName = ClassName.get((String)value.getClass().getPackage().getName(), (String)value.getClass().getSimpleName(), (String[])new String[0]);
        return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{enumName, value});
    }

    private List<FieldMeta> orderedFields(List<Field> fields, Class<?> clazz) {
        boolean sortedAlphabetically;
        List<FieldMeta> fieldMetas = this.transform(fields, clazz);
        if (!this.configuration.isNativeSerializationEnabled()) {
            return fieldMetas;
        }
        ArrayList<FieldMeta> sortedFields = new ArrayList<FieldMeta>();
        JsonPropertyOrder propertyOrder = Helper.getAnnotation(clazz, JsonPropertyOrder.class);
        if (propertyOrder != null && propertyOrder.value().length > 0) {
            for (String name : propertyOrder.value()) {
                int index = this.findField(name, fieldMetas);
                if (index < 0) continue;
                sortedFields.add(fieldMetas.remove(index));
            }
        }
        if (!(sortedAlphabetically = this.configuration.serializationProperties().contains((Object)SerializationProperty.SORT_PROPERTIES_ALPHABETICALLY))) {
            sortedFields.addAll(fieldMetas);
            return sortedFields;
        }
        fieldMetas.sort(Comparator.comparing(FieldMeta::getSerializableName));
        sortedFields.addAll(fieldMetas);
        return sortedFields;
    }

    private List<FieldMeta> transform(List<Field> fields, Class<?> clazz) {
        return fields.stream().map(field -> new FieldMeta((Field)field, clazz)).collect(Collectors.toList());
    }

    private int findField(String name, List<FieldMeta> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            if (!fields.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void addSubTypeControl(Class<?> clazz, List<FieldMeta> fields) {
        if (!this.configuration.isNativeSerializationEnabled()) {
            return;
        }
        JsonTypeInfo jsonTypeInfo = Helper.getAnnotation(clazz, JsonTypeInfo.class);
        JsonSubTypes jsonSubTypes = Helper.getAnnotation(clazz, JsonSubTypes.class);
        if (jsonTypeInfo == null || jsonSubTypes == null) {
            return;
        }
        if (!jsonTypeInfo.include().equals((Object)JsonTypeInfo.As.PROPERTY)) {
            return;
        }
        Optional<JsonSubTypes.Type> subType = Arrays.stream(jsonSubTypes.value()).filter(t -> t.value().equals(clazz)).findFirst();
        if (!subType.isPresent()) {
            return;
        }
        fields.add(0, new FieldMeta(jsonTypeInfo.property(), clazz, subType.get().name()));
    }

    private void resolveInclusionLevel(Class<?> clazz, FieldMeta fieldMeta) {
        JsonSerialize classJsonSerialize = Helper.getAnnotation(clazz, JsonSerialize.class);
        JsonInclude classJsonInclude = Helper.getAnnotation(clazz, JsonInclude.class);
        JsonInclude.Include classInclusion = null;
        if (classJsonInclude == null && classJsonSerialize != null) {
            classInclusion = this.mapJsonSerialize(classJsonSerialize.include());
        } else if (classJsonInclude != null) {
            classInclusion = classJsonInclude.value();
        }
        JsonSerialize fieldJsonSerialize = fieldMeta.getField().getAnnotation(JsonSerialize.class);
        JsonInclude fieldJsonInclude = fieldMeta.getField().getAnnotation(JsonInclude.class);
        JsonInclude.Include fieldInclusion = null;
        if (fieldJsonInclude == null && fieldJsonSerialize != null) {
            fieldInclusion = this.mapJsonSerialize(fieldJsonSerialize.include());
        } else if (fieldJsonInclude != null) {
            fieldInclusion = fieldJsonInclude.value();
        }
        fieldMeta.setInclusionLevel(Optional.ofNullable(fieldInclusion).orElse(Optional.ofNullable(classInclusion).orElse(JsonInclude.Include.ALWAYS)));
    }

    private JsonInclude.Include mapJsonSerialize(JsonSerialize.Inclusion inclusion) {
        switch (inclusion) {
            case NON_NULL: {
                return JsonInclude.Include.NON_NULL;
            }
            case NON_EMPTY: {
                return JsonInclude.Include.NON_EMPTY;
            }
            case NON_DEFAULT: {
                return JsonInclude.Include.NON_DEFAULT;
            }
        }
        return JsonInclude.Include.ALWAYS;
    }

    private CodeBlock constructInclusionCondition(FieldMeta fieldMeta) {
        Field field = fieldMeta.getField();
        String getterName = Helper.getGetterName(field.getName(), Helper.isBoolean(field.getType()), field.getType().isPrimitive());
        if (field.getType().isPrimitive()) {
            if (fieldMeta.getInclusionLevel() == JsonInclude.Include.NON_DEFAULT) {
                Object value = Defaults.defaultValue(field.getType());
                return CodeBlock.of((String)"if ($L.$L() != $L)", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName, value});
            }
            fieldMeta.setMaskable(false);
            return null;
        }
        switch (fieldMeta.getInclusionLevel()) {
            case NON_DEFAULT: 
            case NON_NULL: {
                return CodeBlock.of((String)"if ($L.$L() != null)", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName});
            }
            case NON_EMPTY: {
                if (field.getType().isArray()) {
                    return CodeBlock.of((String)"if ($L.$L() != null && $L.$L().length > 0)", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName, Strings.OBJECT_PARAMETER, getterName});
                }
                if (Helper.getEmptiableTypes().stream().noneMatch(t -> t.isAssignableFrom(field.getType()))) {
                    fieldMeta.setMaskable(false);
                    return null;
                }
                return CodeBlock.of((String)"if ($L.$L() != null && !$L.$L().isEmpty())", (Object[])new Object[]{Strings.OBJECT_PARAMETER, getterName, Strings.OBJECT_PARAMETER, getterName});
            }
        }
        fieldMeta.setMaskable(false);
        return null;
    }
}

