/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.processor.BaseOverrideProcessor;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;

public class NoOpOverrideProcessor
extends BaseOverrideProcessor {
    public NoOpOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        super(configuration, cloakBuilder);
    }

    public TypeSpec createOverride(Rule rule) {
        String implName = Helper.getNoOpImplementationName(rule);
        MethodSpec.Builder methodBuilder = this.generateOverrideMethod(rule, Object.class);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.beginControlFlow("if ($L instanceof String)", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.addStatement("return $S + $L + $S", new Object[]{"\"", Strings.OBJECT_PARAMETER, "\""});
            methodBuilder.nextControlFlow("else if ($L instanceof Character)", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.beginControlFlow("if ((char) $L == Character.valueOf('\\u0000'))", new Object[]{Strings.OBJECT_PARAMETER});
            methodBuilder.addStatement("return $S", new Object[]{"\"\\u0000\""});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return $S + String.valueOf((char) $L) + $S", new Object[]{"\"", Strings.OBJECT_PARAMETER, "\""});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("return String.valueOf($L)", new Object[]{Strings.OBJECT_PARAMETER});
        }
        return this.generateImplementationType(rule, Object.class, implName, methodBuilder.build());
    }
}

