/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.masquerade.processor;

import com.flipkart.masquerade.Configuration;
import com.flipkart.masquerade.rule.Rule;
import com.flipkart.masquerade.util.Helper;
import com.flipkart.masquerade.util.Strings;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public abstract class BaseOverrideProcessor {
    protected final Configuration configuration;
    protected final TypeSpec.Builder cloakBuilder;

    public BaseOverrideProcessor(Configuration configuration, TypeSpec.Builder cloakBuilder) {
        this.configuration = configuration;
        this.cloakBuilder = cloakBuilder;
    }

    protected MethodSpec.Builder generateOverrideMethod(Rule rule, Class<?> clazz) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)Strings.INTERFACE_METHOD);
        methodBuilder.addAnnotation(Override.class);
        methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.addParameter(clazz, Strings.OBJECT_PARAMETER, new Modifier[0]);
        methodBuilder.addParameter(rule.getEvaluatorClass(), "eval", new Modifier[0]);
        methodBuilder.addParameter((TypeName)Helper.getEntryClass(this.configuration), Strings.CLOAK_PARAMETER, new Modifier[0]);
        if (this.configuration.isNativeSerializationEnabled()) {
            methodBuilder.returns(String.class);
        }
        return methodBuilder;
    }

    protected TypeSpec generateImplementationType(Rule rule, Class<?> clazz, String implName, MethodSpec method) {
        TypeSpec.Builder implBuilder = TypeSpec.classBuilder((String)implName);
        implBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        implBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Helper.getRuleInterface(this.configuration, rule), (TypeName[])new TypeName[]{TypeName.get(clazz)}));
        implBuilder.addMethod(method);
        return implBuilder.build();
    }
}

