/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.rules.type;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.SubTypeModel;
import com.flipkart.lyrics.model.TypeModel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;

public class SubTypesRule {
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel, Tune configuration) {
        if (typeModel.getSubTypes() == null) {
            return;
        }
        SubTypeModel subTypeModel = typeModel.getSubTypes();
        if (configuration.areJacksonStyleAnnotationsNeeded()) {
            AnnotationSpec typeInfoAnnotation = AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", new Object[]{"JsonTypeInfo.Id.NAME"}).addMember("include", "$L", new Object[]{"JsonTypeInfo.As.PROPERTY"}).addMember("property", "$S", new Object[]{subTypeModel.getProperty()}).build();
            AnnotationSpec.Builder subTypesBuilder = AnnotationSpec.builder(JsonSubTypes.class);
            for (Map.Entry<String, String> subType : subTypeModel.getSubTypeMapping().entrySet()) {
                subTypesBuilder.addMember("value", "$L", new Object[]{AnnotationSpec.builder(JsonSubTypes.Type.class).addMember("value", "$T.class", new Object[]{Helper.getClassName(subType.getValue())}).addMember("name", "$S", new Object[]{subType.getKey()}).build()});
            }
            typeSpec.addAnnotation(typeInfoAnnotation);
            typeSpec.addAnnotation(subTypesBuilder.build());
        }
    }
}

