/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.rules;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.rules.FieldAnnotationRule;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;

public class NamedAsRule
implements FieldAnnotationRule {
    @Override
    public void process(FieldSpec.Builder fieldSpec, FieldModel fieldModel, Tune configuration) {
        AnnotationSpec annotationSpec;
        if (Helper.isNullOrEmpty(fieldModel.getNamedAs())) {
            return;
        }
        String jsonProperty = fieldModel.getNamedAs();
        if (configuration.areJacksonStyleAnnotationsNeeded()) {
            annotationSpec = AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{jsonProperty}).build();
            fieldSpec.addAnnotation(annotationSpec);
        }
        if (configuration.areGsonStyleAnnotationsNeeded()) {
            annotationSpec = AnnotationSpec.builder(SerializedName.class).addMember("value", "$S", new Object[]{jsonProperty}).build();
            fieldSpec.addAnnotation(annotationSpec);
            fieldSpec.addAnnotation(Expose.class);
        }
    }
}

