/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.annotations;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.AnnotationModel;
import com.flipkart.lyrics.model.TypeModel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClassAnnotationHandler {
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel, Tune configuration) {
        List<AnnotationModel> classAnnotations = this.consolidateClassAnnotations(configuration, typeModel);
        for (AnnotationModel model : classAnnotations) {
            ClassName annotationName = Helper.getClassName(model.getClassName());
            AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder((ClassName)annotationName);
            if (!Helper.isNullOrEmpty(model.getMembers())) {
                for (Map.Entry<String, String> entry : model.getMembers().entrySet()) {
                    annotationBuilder.addMember(entry.getKey(), entry.getValue(), new Object[0]);
                }
            }
            typeSpec.addAnnotation(annotationBuilder.build());
        }
    }

    private List<AnnotationModel> consolidateClassAnnotations(Tune configuration, TypeModel typeModel) {
        ArrayList<AnnotationModel> classAnnotations = new ArrayList<AnnotationModel>();
        if (!Helper.isNullOrEmpty(configuration.getClassLevelAnnotations())) {
            configuration.getClassLevelAnnotations().forEach(classAnnotations::add);
        }
        if (!Helper.isNullOrEmpty(typeModel.getAnnotations())) {
            typeModel.getAnnotations().forEach(classAnnotations::add);
        }
        return classAnnotations;
    }
}

