/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.json;

import com.flipkart.lyrics.Song;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.json.JsonMapper;
import com.flipkart.lyrics.model.TypeModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public final class Lyrics {
    private final Song song;
    private final File target;

    public Lyrics(Tune tune, File target) {
        if (tune == null) {
            throw new IllegalArgumentException("Tune cannot be null");
        }
        if (target == null || !target.isDirectory()) {
            throw new IllegalArgumentException("The target file should be a directory");
        }
        this.song = new Song(tune);
        this.target = target;
    }

    public void compose(boolean cleanTarget, File ... sources) {
        if (sources == null || sources.length == 0) {
            throw new IllegalArgumentException("List of source files cannot be empty");
        }
        if (cleanTarget) {
            Arrays.stream(this.target.listFiles()).forEach(this::deleteFiles);
        }
        for (File source : sources) {
            this.generateClasses("", source);
        }
    }

    private void generateClasses(String pkg, File source) {
        pkg = pkg + source.getName() + ".";
        if (source.isDirectory()) {
            String finalPkg = pkg;
            Arrays.stream(source.listFiles()).forEach(file -> this.generateClasses(finalPkg, (File)file));
        } else {
            this.generate(source, pkg);
        }
    }

    private void generate(File source, String pkg) {
        String fullName = source.getName();
        if (!fullName.endsWith(".json")) {
            System.out.println(String.format("Skipping %s, not a JSON file", source.getAbsolutePath()));
            return;
        }
        try {
            TypeModel typeModel = (TypeModel)JsonMapper.get().readValue(source, TypeModel.class);
            String name = fullName.replace(".json", "");
            pkg = pkg.substring(0, pkg.length() - 1);
            this.song.createType(name, pkg, typeModel, this.target);
        }
        catch (IOException e) {
            System.out.println("Error while processing " + source.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void deleteFiles(File file) {
        if (file.isDirectory()) {
            Arrays.stream(file.listFiles()).forEach(this::deleteFiles);
        }
        file.delete();
    }
}

