/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.supertypes;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.model.VariableModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.TypeSpec;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class InterfaceHandler
extends Handler {
    public InterfaceHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        HashSet<VariableModel> interfaceDefinitions = new HashSet<VariableModel>();
        interfaceDefinitions.addAll(this.tune.interfaces());
        interfaceDefinitions.addAll(typeModel.getInterfaces());
        if (interfaceDefinitions.size() == 0) {
            return;
        }
        List interfaces = interfaceDefinitions.stream().map(model -> Helper.getResolvedTypeName(model, this.metaInfo.getGenericVariables())).collect(Collectors.toList());
        typeSpec.addSuperinterfaces(interfaces);
    }
}

