/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.constructors;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class OrderedConstructorHandler
extends Handler {
    public OrderedConstructorHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        List<String> fieldOrder = typeModel.getFieldOrder();
        if (Helper.isNullOrEmpty(fieldOrder)) {
            return;
        }
        Map fields = typeBuilder.build().fieldSpecs.stream().collect(Collectors.toMap(field -> field.name, Function.identity()));
        MethodSpec.Builder orderedConstructor = MethodSpec.constructorBuilder();
        for (String field2 : fieldOrder) {
            orderedConstructor.addParameter(((FieldSpec)fields.get((Object)field2)).type, field2, new Modifier[0]);
            orderedConstructor.addStatement("this.$L = $L", new Object[]{field2, field2});
        }
        typeBuilder.addMethod(orderedConstructor.build());
    }
}

