/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EqualsAndHashCodeHandler
extends Handler {
    public EqualsAndHashCodeHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        if (!this.tune.areHashCodeAndEqualsNeeded()) {
            return;
        }
        String className = this.metaInfo.getClassName();
        Map<String, FieldModel> fieldModels = typeModel.getFields();
        List nonStaticFields = fieldModels.entrySet().stream().filter(entry -> !((FieldModel)entry.getValue()).isExcludeFromEqualsAndHashCode() && !Arrays.stream(((FieldModel)entry.getValue()).getModifiers()).anyMatch(modifier -> modifier.equals((Object)Modifier.STATIC))).map(Map.Entry::getKey).collect(Collectors.toList());
        MethodSpec.Builder equalsBuilder = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addAnnotation(Override.class).addParameter(Object.class, "o", new Modifier[0]);
        MethodSpec.Builder hashCodeBuilder = MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addAnnotation(Override.class);
        equalsBuilder.addStatement("if (this == o) return true", new Object[0]);
        equalsBuilder.addStatement("if (!(o instanceof $L)) return false", new Object[]{className});
        equalsBuilder.addCode("\n", new Object[0]);
        equalsBuilder.addStatement("$L that = ($L) o", new Object[]{className, className});
        equalsBuilder.addCode("\n", new Object[0]);
        ClassName equalsBuilderClass = ClassName.get(EqualsBuilder.class);
        equalsBuilder.addCode("return new $T()\n", new Object[]{equalsBuilderClass});
        equalsBuilder.addCode("\t\t.appendSuper(super.equals(that))\n", new Object[]{equalsBuilderClass});
        ClassName hashCodeBuilderClass = ClassName.get(HashCodeBuilder.class);
        hashCodeBuilder.addCode("return new $T()\n", new Object[]{hashCodeBuilderClass});
        hashCodeBuilder.addCode("\t\t.appendSuper(super.hashCode())\n", new Object[]{hashCodeBuilderClass});
        for (String field : nonStaticFields) {
            equalsBuilder.addCode("\t\t.append($L, that.$L)\n", new Object[]{field, field});
            hashCodeBuilder.addCode("\t\t.append($L)\n", new Object[]{field});
        }
        equalsBuilder.addCode("\t\t.isEquals();\n", new Object[0]);
        hashCodeBuilder.addCode("\t\t.toHashCode();\n", new Object[0]);
        typeBuilder.addMethod(equalsBuilder.build());
        typeBuilder.addMethod(hashCodeBuilder.build());
    }
}

