/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.fields;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.processor.methods.GetterHandler;
import com.flipkart.lyrics.processor.methods.SetterHandler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;

public class FieldsHandler
extends Handler {
    public FieldsHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        for (String key : typeModel.getFields().keySet()) {
            FieldModel fieldModel = typeModel.getFields().get(key);
            FieldSpec.Builder fieldBuilder = fieldModel.getFieldType().getHandler().process(typeBuilder, key, this.tune, fieldModel, this.metaInfo.getGenericVariables());
            this.handleFieldRules(fieldBuilder, fieldModel);
            FieldSpec fieldSpec = fieldBuilder.build();
            typeBuilder.addField(fieldSpec);
            if (!this.tune.areAccessorsNeeded()) continue;
            this.generateGetterAndSetter(typeBuilder, fieldSpec, fieldModel);
        }
    }

    private void generateGetterAndSetter(TypeSpec.Builder typeBuilder, FieldSpec fieldSpec, FieldModel fieldModel) {
        MethodSpec.Builder getter = new GetterHandler().process(fieldSpec, fieldModel);
        MethodSpec.Builder setter = new SetterHandler().process(fieldSpec, fieldModel);
        if (fieldModel.isRequired()) {
            this.metaInfo.getValidationAnnotatorStyles().forEach(style -> style.processRequiredRuleForGetters(getter, fieldModel));
            this.metaInfo.getValidationAnnotatorStyles().forEach(style -> style.processRequiredRuleForSetters(setter, fieldModel));
        } else {
            this.metaInfo.getValidationAnnotatorStyles().forEach(style -> style.processNotRequiredRuleForGetters(getter, fieldModel));
            this.metaInfo.getValidationAnnotatorStyles().forEach(style -> style.processNotRequiredRuleForSetters(setter, fieldModel));
        }
        typeBuilder.addMethod(getter.build());
        typeBuilder.addMethod(setter.build());
    }

    private void handleFieldRules(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
        this.ruleSet.getInclusionRule().process(fieldSpec, fieldModel);
        this.ruleSet.getNamedAsRule().process(fieldSpec, fieldModel);
        this.ruleSet.getRequiredRule().process(fieldSpec, fieldModel);
        this.ruleSet.getNotRequiredRule().process(fieldSpec, fieldModel);
    }
}

