/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.annotators;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.flipkart.lyrics.annotators.AnnotationStyle;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.InclusionType;
import com.flipkart.lyrics.model.SubTypeModel;
import com.flipkart.lyrics.model.TypeModel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;

public class JacksonStyle
extends AnnotationStyle {
    @Override
    public void processNamedAsRule(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
        String jsonProperty = fieldModel.getNamedAs();
        AnnotationSpec annotationSpec = AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{jsonProperty}).build();
        fieldSpec.addAnnotation(annotationSpec);
    }

    @Override
    public void processInclusionRule(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
        InclusionType inclusion = fieldModel.getInclusion();
        AnnotationSpec annotationSpec = AnnotationSpec.builder(JsonSerialize.class).addMember("include", "JsonSerialize.Inclusion.$L", new Object[]{inclusion}).build();
        fieldSpec.addAnnotation(annotationSpec);
    }

    @Override
    public void processGlobalInclusionRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        AnnotationSpec annotationSpec = AnnotationSpec.builder(JsonSerialize.class).addMember("include", "JsonSerialize.Inclusion.$L", new Object[]{typeModel.getInclusion()}).build();
        typeSpec.addAnnotation(annotationSpec);
    }

    @Override
    public void processSubTypeRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        SubTypeModel subTypeModel = typeModel.getSubTypes();
        AnnotationSpec typeInfoAnnotation = AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", new Object[]{"JsonTypeInfo.Id.NAME"}).addMember("include", "$L", new Object[]{"JsonTypeInfo.As.PROPERTY"}).addMember("property", "$S", new Object[]{subTypeModel.getProperty()}).build();
        AnnotationSpec.Builder subTypesBuilder = AnnotationSpec.builder(JsonSubTypes.class);
        for (Map.Entry<String, String> subType : subTypeModel.getSubTypeMapping().entrySet()) {
            subTypesBuilder.addMember("value", "$L", new Object[]{AnnotationSpec.builder(JsonSubTypes.Type.class).addMember("value", "$T.class", new Object[]{Helper.getClassName(subType.getValue())}).addMember("name", "$S", new Object[]{subType.getKey()}).build()});
        }
        typeSpec.addAnnotation(typeInfoAnnotation);
        typeSpec.addAnnotation(subTypesBuilder.build());
    }
}

