/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics;

import com.flipkart.lyrics.annotators.AnnotationStyle;
import com.flipkart.lyrics.annotators.validations.ValidationAnnotatorStyle;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.sets.DefaultHandlerSet;
import com.flipkart.lyrics.sets.DefaultRuleSet;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Song {
    private Tune tune;

    public Song(Tune tune) {
        this.tune = tune;
    }

    public void createType(String name, String fullPackage, TypeModel typeModel, File targetFolder) throws IOException {
        List<AnnotationStyle> annotationStyles = Helper.processAnnotationStyles(this.tune);
        List<ValidationAnnotatorStyle> validationAnnotatorStyles = Helper.processValidationAnnotationStyles(this.tune);
        MetaInfo metaInfo = new MetaInfo(name, fullPackage, Helper.getTypeVariables(typeModel.getGenericVariables()), annotationStyles, validationAnnotatorStyles);
        DefaultRuleSet ruleSet = new DefaultRuleSet(this.tune, metaInfo);
        DefaultHandlerSet handlerSet = new DefaultHandlerSet(this.tune, metaInfo, ruleSet);
        TypeSpec.Builder typeBuilder = typeModel.getType().getCreator().process(handlerSet, typeModel);
        JavaFile javaFile = JavaFile.builder((String)fullPackage, (TypeSpec)typeBuilder.build()).indent("    ").skipJavaLangImports(true).build();
        javaFile.writeTo(targetFolder);
    }
}

