/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ToStringHandler {
    public void process(TypeSpec.Builder typeBuilder, String className, Map<String, FieldModel> fieldModels, Tune configuration) {
        if (!configuration.isToStringNeeded()) {
            return;
        }
        List nonStaticFields = fieldModels.entrySet().stream().filter(entry -> !((FieldModel)entry.getValue()).isExcludeFromToString() && !Arrays.stream(((FieldModel)entry.getValue()).getModifiers()).anyMatch(modifier -> modifier.equals((Object)Modifier.STATIC))).map(Map.Entry::getKey).collect(Collectors.toList());
        MethodSpec.Builder toStringBuilder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class);
        if (!configuration.useCommonsLang3()) {
            toStringBuilder.addStatement("final StringBuilder sb = new StringBuilder(\"$L{\")", new Object[]{className});
            if (nonStaticFields.size() > 0) {
                String firstField = (String)nonStaticFields.get(0);
                toStringBuilder.addStatement("sb.append(\"$L=\").append($L)", new Object[]{firstField, firstField});
                if (nonStaticFields.size() > 1) {
                    for (String field : nonStaticFields.subList(1, nonStaticFields.size())) {
                        toStringBuilder.addStatement("sb.append(\", $L=\").append($L);", new Object[]{field, field});
                    }
                }
            }
            toStringBuilder.addStatement("sb.append('}')", new Object[0]);
            toStringBuilder.addStatement("return sb.toString()", new Object[0]);
        } else {
            ClassName toStringBuilderClass = ClassName.get(ToStringBuilder.class);
            toStringBuilder.addCode("return new $T(this)\n", new Object[]{toStringBuilderClass});
            for (String field : nonStaticFields) {
                toStringBuilder.addCode("\t\t.append($S, $L)\n", new Object[]{field, field});
            }
            toStringBuilder.addCode("\t\t.toString();\n", new Object[0]);
        }
        typeBuilder.addMethod(toStringBuilder.build());
    }
}

