/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.fields;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.annotations.FieldAnnotationHandler;
import com.flipkart.lyrics.processor.methods.GetterHandler;
import com.flipkart.lyrics.processor.methods.SetterHandler;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.HashMap;
import java.util.Map;

public class FieldsHandler {
    public Map<String, FieldSpec> process(TypeSpec.Builder typeBuilder, TypeModel typeModel, Tune configuration, Map<String, TypeVariableName> typeVariableNames) {
        HashMap<String, FieldSpec> fields = new HashMap<String, FieldSpec>();
        for (String key : typeModel.getFields().keySet()) {
            FieldModel fieldModel = typeModel.getFields().get(key);
            FieldSpec.Builder fieldBuilder = fieldModel.getFieldType().getHandler().process(typeBuilder, key, configuration, fieldModel, typeVariableNames);
            new FieldAnnotationHandler().process(fieldBuilder, fieldModel, configuration);
            FieldSpec fieldSpec = fieldBuilder.build();
            fields.put(key, fieldSpec);
            typeBuilder.addField(fieldSpec);
            if (!configuration.areAccessorsNeeded()) continue;
            this.generateGetterAndSetter(typeBuilder, fieldSpec, fieldModel);
        }
        return fields;
    }

    public Map<String, FieldSpec> process(TypeSpec.Builder typeBuilder, TypeModel typeModel, Tune configuration) {
        return this.process(typeBuilder, typeModel, configuration, new HashMap<String, TypeVariableName>());
    }

    private void generateGetterAndSetter(TypeSpec.Builder typeBuilder, FieldSpec fieldSpec, FieldModel fieldModel) {
        typeBuilder.addMethod(new GetterHandler().process(fieldSpec, fieldModel));
        typeBuilder.addMethod(new SetterHandler().process(fieldSpec, fieldModel));
    }
}

