/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.annotators;

import com.flipkart.lyrics.annotators.AnnotatorStyle;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.specs.AnnotationSpec;
import com.flipkart.lyrics.specs.FieldSpec;
import com.flipkart.lyrics.specs.MethodSpec;
import com.flipkart.lyrics.specs.TypeSpec;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.List;

public class GsonStyle
extends AnnotatorStyle {
    @Override
    public void processNamedAsRule(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
        String jsonProperty = fieldModel.getNamedAs();
        AnnotationSpec annotationSpec = AnnotationSpec.builder(SerializedName.class).addMember("value", "$S", jsonProperty).build();
        fieldSpec.addAnnotation(annotationSpec);
        fieldSpec.addAnnotation(Expose.class);
    }

    @Override
    public void processInclusionRule(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
    }

    @Override
    public void processGlobalInclusionRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
    }

    @Override
    public void processSubTypeRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
    }

    @Override
    public void processPropertyOrderRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
    }

    @Override
    public void processConstructorOrderRule(MethodSpec.Builder methodSpec, TypeModel typeModel, List<String> constructorFields) {
        AnnotationSpec.Builder constructorPropertyOrderBuilder = AnnotationSpec.builder(ConstructorProperties.class);
        for (String field : constructorFields) {
            constructorPropertyOrderBuilder.addMember("value", "$S", field);
        }
        methodSpec.addAnnotation(constructorPropertyOrderBuilder.build());
    }
}

