/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.FieldType;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.sets.RuleSet;
import com.flipkart.lyrics.specs.FieldSpec;
import com.flipkart.lyrics.specs.MethodSpec;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.ParameterSpec;
import com.flipkart.lyrics.specs.TypeSpec;

public class SetterHandler {
    private Tune tune;
    private MetaInfo metaInfo;
    private RuleSet ruleSet;

    public SetterHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        this.tune = tune;
        this.metaInfo = metaInfo;
        this.ruleSet = ruleSet;
    }

    public void process(TypeSpec.Builder typeBuilder, FieldSpec fieldSpec, FieldModel fieldModel) {
        String methodName = Helper.getGetterSetterName(fieldSpec.name, true, fieldModel.getFieldType() == FieldType.BOOLEAN, fieldModel.isPrimitive());
        MethodSpec.Builder builder = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).returns(Void.TYPE).addStatement("this.$L = $L", fieldSpec.name, fieldSpec.name);
        ParameterSpec.Builder param = ParameterSpec.builder(fieldSpec.type, fieldSpec.name, new Modifier[0]);
        this.ruleSet.getSetterRequiredRule().process(builder, fieldModel, param);
        this.ruleSet.getSetterNotRequiredRule().process(builder, fieldModel, param);
        builder.addParameter(param.build());
        typeBuilder.addMethod(builder.build());
    }
}

