/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.annotators;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.flipkart.lyrics.annotators.AnnotatorStyle;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.InclusionType;
import com.flipkart.lyrics.model.SubTypeModel;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.specs.AnnotationSpec;
import com.flipkart.lyrics.specs.FieldSpec;
import com.flipkart.lyrics.specs.TypeSpec;
import java.util.List;
import java.util.Map;

public class JacksonStyle
extends AnnotatorStyle {
    @Override
    public void processNamedAsRule(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
        String jsonProperty = fieldModel.getNamedAs();
        AnnotationSpec annotationSpec = AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", jsonProperty).build();
        fieldSpec.addAnnotation(annotationSpec);
    }

    @Override
    public void processInclusionRule(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
        InclusionType inclusion = fieldModel.getInclusion();
        AnnotationSpec annotationSpec = AnnotationSpec.builder(JsonSerialize.class).addMember("include", "JsonSerialize.Inclusion.$L", new Object[]{inclusion}).build();
        fieldSpec.addAnnotation(annotationSpec);
    }

    @Override
    public void processGlobalInclusionRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        AnnotationSpec annotationSpec = AnnotationSpec.builder(JsonSerialize.class).addMember("include", "JsonSerialize.Inclusion.$L", new Object[]{typeModel.getInclusion()}).build();
        typeSpec.addAnnotation(annotationSpec);
    }

    @Override
    public void processSubTypeRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        SubTypeModel subTypeModel = typeModel.getSubTypes();
        AnnotationSpec.Builder typeInfoAnnotation = AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", "JsonTypeInfo.Id.NAME").addMember("include", "$L", "JsonTypeInfo.As." + (subTypeModel.isExistingProperty() ? "EXISTING_PROPERTY" : "PROPERTY")).addMember("property", "$S", subTypeModel.getProperty());
        if (subTypeModel.isVisible()) {
            typeInfoAnnotation.addMember("visible", "$L", subTypeModel.isVisible());
        }
        AnnotationSpec.Builder subTypesBuilder = AnnotationSpec.builder(JsonSubTypes.class);
        for (Map.Entry<String, String> subType : subTypeModel.getSubTypeMapping().entrySet()) {
            subTypesBuilder.addMember("value", "$L", AnnotationSpec.builder(JsonSubTypes.Type.class).addMember("value", "$T.class", Helper.getClassName(subType.getValue())).addMember("name", "$S", subType.getKey()).build());
        }
        typeSpec.addAnnotation(typeInfoAnnotation.build());
        typeSpec.addAnnotation(subTypesBuilder.build());
    }

    @Override
    public void processPropertyOrderRule(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        List<String> fieldOrder = typeModel.getFieldOrder();
        AnnotationSpec.Builder propertyOrderBuilder = AnnotationSpec.builder(JsonPropertyOrder.class);
        for (String field : fieldOrder) {
            propertyOrderBuilder.addMember("value", "$S", field);
        }
        typeSpec.addAnnotation(propertyOrderBuilder.build());
    }
}

