/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.supertypes;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.model.VariableModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.flipkart.lyrics.specs.TypeSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public class SpecialInterfaceHandler
extends Handler {
    public SpecialInterfaceHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        Map specialHandlers = Optional.ofNullable(this.tune.getSpecialInterfacesHandler()).orElseGet(HashMap::new);
        HashSet<VariableModel> interfaces = new HashSet<VariableModel>();
        interfaces.addAll(this.tune.interfaces());
        interfaces.addAll(typeModel.getInterfaces());
        interfaces.forEach(i -> Optional.ofNullable(specialHandlers.get(i.getType())).ifPresent(fn -> fn.accept(typeSpec, typeModel, this.metaInfo)));
    }
}

