/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.fields;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.Primitive;
import com.flipkart.lyrics.processor.fields.FieldTypeHandler;
import com.flipkart.lyrics.specs.ArrayTypeName;
import com.flipkart.lyrics.specs.FieldSpec;
import com.flipkart.lyrics.specs.TypeName;
import com.flipkart.lyrics.specs.TypeSpec;

public class PrimitiveTypeHandler
extends FieldTypeHandler {
    private Primitive primitive;

    public PrimitiveTypeHandler(Tune tune, MetaInfo metaInfo, Primitive primitive) {
        super(tune, metaInfo);
        this.primitive = primitive;
    }

    @Override
    public FieldSpec.Builder process(TypeSpec.Builder typeSpec, String key, FieldModel fieldModel) {
        Class aClass = fieldModel.isPrimitive() ? this.primitive.getUnboxed() : this.primitive.getBoxed();
        TypeName typeName = fieldModel.isArray() ? ArrayTypeName.of(aClass) : TypeName.get(aClass);
        FieldSpec.Builder builder = FieldSpec.builder(typeName, key, Helper.resolveModifiers(this.tune, fieldModel));
        if (fieldModel.getInitializeWith() != null) {
            builder.initializer("$L", fieldModel.getInitializeWith().getValue());
        }
        return builder;
    }
}

