/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.fields;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.processor.fields.FieldAdditionalHandler;
import com.flipkart.lyrics.processor.fields.FieldModificationHandler;
import com.flipkart.lyrics.processor.methods.GetterHandler;
import com.flipkart.lyrics.processor.methods.SetterHandler;
import com.flipkart.lyrics.sets.RuleSet;
import com.flipkart.lyrics.specs.FieldSpec;
import com.flipkart.lyrics.specs.TypeSpec;
import java.util.List;
import java.util.stream.Collectors;

public class FieldsHandler
extends Handler {
    public FieldsHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        for (String key : typeModel.getFields().keySet()) {
            FieldModel fieldModel = typeModel.getFields().get(key);
            FieldSpec.Builder originalFieldBuilder = Helper.getFieldTypeHandler(fieldModel.getFieldType(), this.tune.getFieldTypeHandlerSet()).process(typeBuilder, key, fieldModel);
            FieldSpec.Builder fieldBuilder = this.tune.getFieldModificationHandlers().entrySet().stream().filter(e -> fieldModel.getAdditionalFields().get(e.getKey()) != null).findFirst().map(e -> ((FieldModificationHandler)e.getValue()).process(originalFieldBuilder, (String)e.getKey(), fieldModel.getAdditionalFields().get(e.getKey()), fieldModel)).orElse(originalFieldBuilder);
            this.handleFieldRules(fieldBuilder, fieldModel);
            List triggers = this.tune.getFieldsAdditionalPropertiesHandler().entrySet().stream().filter(e -> fieldModel.getAdditionalFields().get(e.getKey()) != null).map(e -> ((FieldAdditionalHandler)e.getValue()).process(fieldBuilder, (String)e.getKey(), fieldModel.getAdditionalFields().get(e.getKey()))).collect(Collectors.toList());
            boolean hideField = triggers.stream().anyMatch(b -> b == false);
            if (hideField) continue;
            FieldSpec fieldSpec = fieldBuilder.build();
            typeBuilder.addField(fieldSpec);
            if (!this.tune.areAccessorsNeeded()) continue;
            new GetterHandler(this.tune, this.metaInfo, this.ruleSet).process(typeBuilder, fieldSpec, fieldModel);
            new SetterHandler(this.tune, this.metaInfo, this.ruleSet).process(typeBuilder, fieldSpec, fieldModel);
        }
    }

    private void handleFieldRules(FieldSpec.Builder fieldSpec, FieldModel fieldModel) {
        this.ruleSet.getInclusionRule().process(fieldSpec, fieldModel);
        this.ruleSet.getNamedAsRule().process(fieldSpec, fieldModel);
        this.ruleSet.getRequiredRule().process(fieldSpec, fieldModel);
        this.ruleSet.getNotRequiredRule().process(fieldSpec, fieldModel);
        this.ruleSet.getDeprecatedRule().process(fieldSpec, fieldModel);
    }
}

