/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.fields;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.InitializerModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.processor.fields.FieldTypeHandler;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class ObjectTypeHandler
extends FieldTypeHandler {
    public ObjectTypeHandler(Tune tune, MetaInfo metaInfo) {
        super(tune, metaInfo);
    }

    @Override
    public FieldSpec.Builder process(TypeSpec.Builder typeSpec, String key, FieldModel fieldModel) {
        Object typeName = fieldModel.getType() == null ? TypeName.OBJECT : Helper.getResolvedTypeName(fieldModel.getType(), this.metaInfo.getGenericVariables());
        typeName = fieldModel.isArray() ? ArrayTypeName.of((TypeName)typeName) : typeName;
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)key, (Modifier[])Helper.resolveModifiers(this.tune, fieldModel));
        InitializerModel initializeWith = fieldModel.getInitializeWith();
        if (initializeWith != null) {
            if (initializeWith.getValue() != null) {
                ClassName fromType = Helper.getClassName(initializeWith.getFromType());
                builder.initializer("$T.$L", new Object[]{fromType, initializeWith.getValue()});
            } else if (initializeWith.getNewInstanceOf() != null) {
                ClassName instanceOf = Helper.getClassName(initializeWith.getNewInstanceOf());
                String initializerString = "new $T" + (initializeWith.isInferGenerics() ? "<>" : "") + "()";
                builder.initializer(initializerString, new Object[]{instanceOf});
            }
        }
        return builder;
    }
}

