/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.fields;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.Primitive;
import com.flipkart.lyrics.processor.fields.FieldTypeHandler;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;

public class PrimitiveTypeHandler
extends FieldTypeHandler {
    private Primitive primitive;

    public PrimitiveTypeHandler(Tune tune, MetaInfo metaInfo, Primitive primitive) {
        super(tune, metaInfo);
        this.primitive = primitive;
    }

    @Override
    public FieldSpec.Builder process(TypeSpec.Builder typeSpec, String key, FieldModel fieldModel) {
        Class aClass = fieldModel.isPrimitive() ? this.primitive.getUnboxed() : this.primitive.getBoxed();
        ArrayTypeName typeName = fieldModel.isArray() ? ArrayTypeName.of((Type)aClass) : TypeName.get((Type)aClass);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)typeName, (String)key, (Modifier[])Helper.resolveModifiers(this.tune, fieldModel));
        if (fieldModel.getInitializeWith() != null) {
            builder.initializer("$L", new Object[]{fieldModel.getInitializeWith().getValue()});
        }
        return builder;
    }
}

