/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.constructors;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class RequiredFieldsConstructorHandler
extends Handler {
    public RequiredFieldsConstructorHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        if (!this.tune.isRequiredFieldConstructorNeeded()) {
            return;
        }
        Map<String, FieldModel> fields = typeModel.getFields();
        List requiredFields = fields.entrySet().stream().filter(entry -> ((FieldModel)entry.getValue()).isRequired()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (requiredFields.isEmpty()) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (String field : requiredFields) {
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)Helper.processType(fields.get(field), this.metaInfo.getGenericVariables()), (String)field, (Modifier[])new Modifier[0]);
            if (!fields.get(field).isPrimitive()) {
                this.tune.getValidationAnnotatorStyles().forEach(style -> style.processRequiredRuleForConstructor(parameterSpec));
            }
            constructor.addParameter(parameterSpec.build());
            constructor.addStatement("this.$L = $L", new Object[]{field, field});
        }
        typeSpec.addMethod(constructor.build());
    }
}

