/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.android.handlers;

import com.flipkart.lyrics.android.config.AndroidTune;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.processor.instances.EnumValuesHandler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class StringDefValuesHandler
extends Handler {
    public StringDefValuesHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        AndroidTune androidTune = (AndroidTune)this.tune;
        if (!androidTune.createStringDefsFor().contains(this.metaInfo.getFullPackage() + "." + this.metaInfo.getClassName())) {
            new EnumValuesHandler(this.tune, this.metaInfo, this.ruleSet).process(typeBuilder, typeModel);
            return;
        }
        Map values = typeModel.getValues();
        String valuesStr = "";
        for (String key : values.keySet()) {
            valuesStr = valuesStr + key + ", ";
            typeBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)key, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{key}).build());
        }
        AnnotationSpec.Builder retentionAnnotation = AnnotationSpec.builder((ClassName)ClassName.get(Retention.class)).addMember("value", "$T.SOURCE", new Object[]{ClassName.get(RetentionPolicy.class)});
        AnnotationSpec.Builder intDefAnnotation = AnnotationSpec.builder((ClassName)ClassName.get((String)"android.support.annotation", (String)"StringDef", (String[])new String[0])).addMember("value", "{ $L }", new Object[]{valuesStr.substring(0, valuesStr.length() - 2)});
        typeBuilder.addType(TypeSpec.annotationBuilder((String)(this.metaInfo.getClassName() + "Def")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(retentionAnnotation.build()).addAnnotation(intDefAnnotation.build()).build());
    }
}

