/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilienthttpclient.handlers;

import com.flipkart.resilienthttpclient.exceptions.MaxContentLengthExceededException;
import com.flipkart.resilienthttpclient.handlers.BaseAsyncHandlerDecorator;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Objects;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;

public class AsyncHandlerDecoratorForMaxContentLength<T>
extends BaseAsyncHandlerDecorator<T> {
    private final int MAX_CONTENT_LENGTH_IN_BYTES;
    private int contentLengthSoFar;

    public AsyncHandlerDecoratorForMaxContentLength(AsyncHandler<T> innerAsyncHandler, int max_content_length_in_bytes) {
        super(innerAsyncHandler);
        this.MAX_CONTENT_LENGTH_IN_BYTES = max_content_length_in_bytes;
    }

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.contentLengthSoFar = 0;
        return super.onStatusReceived(responseStatus);
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        int contentLength = -1;
        String contentLengthString = headers.get("Content-Length");
        if (Objects.nonNull(contentLengthString)) {
            try {
                contentLength = Integer.parseInt(contentLengthString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.throwExceptionIfNecessary(contentLength);
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        this.contentLengthSoFar += bodyPart.length();
        this.throwExceptionIfNecessary(this.contentLengthSoFar);
        return super.onBodyPartReceived(bodyPart);
    }

    private void throwExceptionIfNecessary(int contentLength) {
        if (contentLength > this.MAX_CONTENT_LENGTH_IN_BYTES) {
            throw new MaxContentLengthExceededException(this.contentLengthSoFar, this.MAX_CONTENT_LENGTH_IN_BYTES);
        }
    }
}

