/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilienthttpclient;

import com.flipkart.resilienthttpclient.exceptions.ServerSideException;
import com.flipkart.resilienthttpclient.handlers.AsyncHandlerSupplier;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;

public class ResilientListenableFuture<T>
implements ListenableFuture<T> {
    private final Object lock = new Object();
    private final CompletableFuture<T> completableFuture;
    private final AsyncHttpClient asyncHttpClient;
    private final Request request;
    private ListenableFuture<T> responseListenableFuture;

    public ResilientListenableFuture(AsyncHttpClient asyncHttpClient, Request request, UnaryOperator<Supplier<CompletionStage<T>>> decorator, AsyncHandlerSupplier<T> handlerSupplier) {
        this.asyncHttpClient = asyncHttpClient;
        this.request = request;
        this.completableFuture = this.prepareCompletionStage(decorator, handlerSupplier);
    }

    private CompletableFuture<T> prepareCompletionStage(UnaryOperator<Supplier<CompletionStage<T>>> decorator, AsyncHandlerSupplier<T> handlerSupplier) {
        Supplier supplier = (Supplier)decorator.apply(this.prepareSupplier(handlerSupplier));
        Supplier<CompletionStage> supplier2 = () -> ResilientListenableFuture.lambda$prepareCompletionStage$1((Supplier)supplier);
        return supplier2.get().toCompletableFuture();
    }

    private Supplier<CompletionStage<T>> prepareSupplier(AsyncHandlerSupplier<T> handlerSupplier) {
        return () -> {
            Object object = this.lock;
            synchronized (object) {
                AsyncHandler handler1 = (AsyncHandler)handlerSupplier.get();
                this.responseListenableFuture = this.asyncHttpClient.executeRequest(this.request, handler1);
                return this.responseListenableFuture.toCompletableFuture();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object object = this.lock;
        synchronized (object) {
            this.responseListenableFuture.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            this.responseListenableFuture.abort(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        Object object = this.lock;
        synchronized (object) {
            this.responseListenableFuture.touch();
        }
    }

    public ListenableFuture<T> addListener(Runnable runnable, Executor exec) {
        if (exec == null) {
            exec = Runnable::run;
        }
        this.completableFuture.whenCompleteAsync((r, v) -> runnable.run(), exec);
        return this;
    }

    public CompletableFuture<T> toCompletableFuture() {
        return this.completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.completableFuture.cancel(mayInterruptIfRunning);
            this.responseListenableFuture.cancel(mayInterruptIfRunning);
            return result;
        }
    }

    public boolean isCancelled() {
        return this.completableFuture.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.responseListenableFuture.isDone();
        }
    }

    public T get() throws InterruptedException, ExecutionException {
        return this.completableFuture.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.completableFuture.get(timeout, unit);
    }

    private static /* synthetic */ CompletionStage lambda$prepareCompletionStage$1(Supplier supplier) {
        CompletableFuture promise = new CompletableFuture();
        ((CompletionStage)supplier.get()).whenComplete((response, throwable) -> {
            try {
                if (Objects.isNull(throwable)) {
                    promise.complete(response);
                    return;
                }
                if (throwable instanceof ServerSideException) {
                    promise.complete(((ServerSideException)throwable).getResponse());
                    return;
                }
                promise.completeExceptionally((Throwable)throwable);
            }
            catch (Throwable newThrowable) {
                promise.completeExceptionally(newThrowable);
            }
        });
        return promise;
    }
}

