/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilienthttpclient;

import com.flipkart.resilience4all.resilience4j.timer.TimerConfig;
import com.flipkart.resilience4all.resilience4j.timer.TimerRegistry;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.metrics.Timer;
import io.github.resilience4j.retry.Retry;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

class ResilientDomainDecoratorFactory {
    private final CircuitBreaker circuitBreaker;
    private final Bulkhead bulkhead;
    private final Retry retry;
    private final ScheduledExecutorService retryExecutor;
    private final Timer serverTimer;
    private final Timer clientTimer;

    private ResilientDomainDecoratorFactory(CircuitBreaker circuitBreaker, Bulkhead bulkhead, Retry retry, ScheduledExecutorService retryExecutor, String domainName, TimerRegistry timerRegistry) {
        this.circuitBreaker = circuitBreaker;
        this.bulkhead = bulkhead;
        this.retry = retry;
        this.retryExecutor = retryExecutor;
        this.serverTimer = timerRegistry.timer(domainName + ".server", TimerConfig.custom().name("com.flipkart.resilience4all.resilienthttpclient." + domainName + ".server").build());
        this.clientTimer = timerRegistry.timer(domainName + ".client", TimerConfig.custom().name("com.flipkart.resilience4all.resilienthttpclient." + domainName + ".client").build());
    }

    static Builder builder() {
        return new Builder();
    }

    <T> UnaryOperator<Supplier<CompletionStage<T>>> create() {
        UnaryOperator identityDecorator = supplier -> supplier;
        UnaryOperator<Supplier<CompletionStage<T>>> serverTimerDecorator = this.createTimerDecorator(this.serverTimer, identityDecorator);
        UnaryOperator<Supplier<CompletionStage<T>>> circuitBreakerDecorator = this.createCircuitBreakerDecorator(serverTimerDecorator);
        UnaryOperator<Supplier<CompletionStage<T>>> bulkheadDecorator = this.createBulkheadDecorator(circuitBreakerDecorator);
        UnaryOperator<Supplier<CompletionStage<T>>> retryDecorator = this.createRetryDecorator(bulkheadDecorator);
        UnaryOperator<Supplier<CompletionStage<T>>> clientTimerDecorator = this.createTimerDecorator(this.clientTimer, retryDecorator);
        return clientTimerDecorator;
    }

    private <T> UnaryOperator<Supplier<CompletionStage<T>>> createCircuitBreakerDecorator(UnaryOperator<Supplier<CompletionStage<T>>> decorator) {
        if (Objects.nonNull(this.circuitBreaker)) {
            return completionStageSupplier -> this.circuitBreaker.decorateCompletionStage((Supplier)decorator.apply((Supplier)completionStageSupplier));
        }
        return decorator;
    }

    private <T> UnaryOperator<Supplier<CompletionStage<T>>> createRetryDecorator(UnaryOperator<Supplier<CompletionStage<T>>> decorator) {
        if (Objects.nonNull(this.retry)) {
            return completionStageSupplier -> Retry.decorateCompletionStage((Retry)this.retry, (ScheduledExecutorService)this.retryExecutor, (Supplier)((Supplier)decorator.apply((Supplier)completionStageSupplier)));
        }
        return decorator;
    }

    private <T> UnaryOperator<Supplier<CompletionStage<T>>> createBulkheadDecorator(UnaryOperator<Supplier<CompletionStage<T>>> decorator) {
        if (Objects.nonNull(this.bulkhead)) {
            return completionStageSupplier -> Bulkhead.decorateCompletionStage((Bulkhead)this.bulkhead, (Supplier)((Supplier)decorator.apply((Supplier)completionStageSupplier)));
        }
        return decorator;
    }

    private <T> UnaryOperator<Supplier<CompletionStage<T>>> createTimerDecorator(Timer timer, UnaryOperator<Supplier<CompletionStage<T>>> decorator) {
        return completionStageSupplier -> Timer.decorateCompletionStageSupplier((Timer)timer, (Supplier)((Supplier)decorator.apply((Supplier)completionStageSupplier)));
    }

    static class Builder {
        private CircuitBreaker circuitBreaker;
        private Bulkhead bulkhead;
        private Retry retry;
        private ScheduledExecutorService retryExecutor;
        private String domainName;
        private TimerRegistry timerRegistry;

        Builder() {
        }

        Builder circuitBreaker(CircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        Builder bulkhead(Bulkhead bulkhead) {
            this.bulkhead = bulkhead;
            return this;
        }

        Builder retry(Retry retry) {
            this.retry = retry;
            return this;
        }

        Builder retryExecutor(ScheduledExecutorService retryExecutor) {
            this.retryExecutor = retryExecutor;
            return this;
        }

        Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        Builder timerRegistry(TimerRegistry timerRegistry) {
            this.timerRegistry = timerRegistry;
            return this;
        }

        ResilientDomainDecoratorFactory build() {
            return new ResilientDomainDecoratorFactory(this.circuitBreaker, this.bulkhead, this.retry, this.retryExecutor, this.domainName, this.timerRegistry);
        }
    }
}

