/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilience4all.metrics.eventstream;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;

public abstract class Resilience4jSampleSseServlet
extends HttpServlet {
    protected static final int DEFAULT_PAUSE_POLLER_THREAD_DELAY_IN_MS = 500;
    private static final Logger logger = LoggerFactory.getLogger(Resilience4jSampleSseServlet.class);
    private static volatile boolean isDestroyed = false;
    protected final Observable<String> sampleStream;
    private final int pausePollerThreadDelayInMs;

    protected Resilience4jSampleSseServlet(Observable<String> sampleStream) {
        this.sampleStream = sampleStream;
        this.pausePollerThreadDelayInMs = 500;
    }

    protected Resilience4jSampleSseServlet(Observable<String> sampleStream, int pausePollerThreadDelayInMs) {
        this.sampleStream = sampleStream;
        this.pausePollerThreadDelayInMs = pausePollerThreadDelayInMs;
    }

    public static void shutdown() {
        isDestroyed = true;
    }

    protected abstract int getMaxNumberConcurrentConnectionsAllowed();

    protected abstract int getNumberCurrentConnections();

    protected abstract int incrementAndGetCurrentConcurrentConnections();

    protected abstract void decrementCurrentConcurrentConnections();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (isDestroyed) {
            response.sendError(503, "Service has been shut down.");
        } else {
            this.handleRequest(request, response);
        }
    }

    public void init() throws ServletException {
        isDestroyed = false;
    }

    public void destroy() {
        isDestroyed = true;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final AtomicBoolean moreDataWillBeSent = new AtomicBoolean(true);
        Subscription sampleSubscription = null;
        int numberConnections = this.incrementAndGetCurrentConcurrentConnections();
        try {
            int maxNumberConnectionsAllowed = this.getMaxNumberConcurrentConnectionsAllowed();
            if (numberConnections > maxNumberConnectionsAllowed) {
                response.sendError(503, "MaxConcurrentConnections reached: " + maxNumberConnectionsAllowed);
            } else {
                response.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
                response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                final PrintWriter writer = response.getWriter();
                sampleSubscription = this.sampleStream.observeOn(Schedulers.io()).subscribe((Subscriber)new Subscriber<String>(){

                    public void onCompleted() {
                        logger.error("HystrixSampleSseServlet: ({}) received unexpected OnCompleted from sample stream", (Object)((Object)((Object)this)).getClass().getSimpleName());
                        moreDataWillBeSent.set(false);
                    }

                    public void onError(Throwable e) {
                        moreDataWillBeSent.set(false);
                    }

                    public void onNext(String sampleDataAsString) {
                        if (sampleDataAsString != null) {
                            writer.print("data: " + sampleDataAsString + "\n\n");
                            if (writer.checkError()) {
                                moreDataWillBeSent.set(false);
                            }
                            writer.flush();
                        }
                    }
                });
                while (moreDataWillBeSent.get() && !isDestroyed) {
                    try {
                        Thread.sleep(this.pausePollerThreadDelayInMs);
                        writer.print("ping: \n\n");
                        if (writer.checkError()) {
                            moreDataWillBeSent.set(false);
                        }
                        writer.flush();
                    }
                    catch (InterruptedException e) {
                        moreDataWillBeSent.set(false);
                    }
                }
            }
        }
        finally {
            this.decrementCurrentConcurrentConnections();
            if (sampleSubscription != null && !sampleSubscription.isUnsubscribed()) {
                sampleSubscription.unsubscribe();
            }
        }
    }
}

