/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilience4all.metrics.eventstream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.resilience4all.metrics.eventstream.HystrixCommandLikeMetrics;
import com.flipkart.resilience4all.metrics.eventstream.HystrixThreadPoolLikeMetrics;
import com.flipkart.resilience4all.metrics.eventstream.Resilience4jSampleSseServlet;
import com.flipkart.resilience4all.resilience4j.timer.TimerRegistry;
import com.netflix.hystrix.metric.consumer.HystrixDashboardStream;
import com.netflix.hystrix.serial.SerialHystrixDashboardData;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.metrics.Timer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class Resilience4jMetricsStreamServlet
extends Resilience4jSampleSseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Resilience4jMetricsStreamServlet.class);
    private static final long serialVersionUID = -7548505095303313237L;
    private static final AtomicInteger concurrentConnections = new AtomicInteger(0);
    private static final int DEFAULT_PAUSE_POLLER_THREAD_DELAY_IN_MS = 1000;

    Resilience4jMetricsStreamServlet(Observable<String> sampleStream) {
        super(sampleStream);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected int getMaxNumberConcurrentConnectionsAllowed() {
        return 5;
    }

    @Override
    protected int getNumberCurrentConnections() {
        return concurrentConnections.get();
    }

    @Override
    protected int incrementAndGetCurrentConcurrentConnections() {
        return concurrentConnections.incrementAndGet();
    }

    @Override
    protected void decrementCurrentConcurrentConnections() {
        concurrentConnections.decrementAndGet();
    }

    public static class Builder {
        private final ObjectMapper objectMapper = new ObjectMapper();
        Map<String, CircuitBreaker> circuitBreakers = new HashMap<String, CircuitBreaker>();
        Map<String, Bulkhead> bulkheads = new HashMap<String, Bulkhead>();
        Map<String, ThreadPoolBulkhead> threadPoolBulkheads = new HashMap<String, ThreadPoolBulkhead>();
        Map<String, Retry> retries = new HashMap<String, Retry>();
        Map<String, TimeLimiter> timeLimiters = new HashMap<String, TimeLimiter>();
        Map<String, Timer> clientTimers = new HashMap<String, Timer>();
        Map<String, Timer> serverTimers = new HashMap<String, Timer>();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
        BulkheadRegistry bulkheadRegistry = BulkheadRegistry.ofDefaults();
        ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry = ThreadPoolBulkheadRegistry.ofDefaults();
        RetryRegistry retryRegistry = RetryRegistry.ofDefaults();
        TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
        TimerRegistry timerRegistry = TimerRegistry.ofDefaults();

        public Builder andCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.circuitBreakers.put(circuitBreaker.getName(), circuitBreaker);
            return this;
        }

        public Builder andBulkhead(Bulkhead bulkhead) {
            this.bulkheads.put(bulkhead.getName(), bulkhead);
            return this;
        }

        public Builder andThreadPoolBulkhed(ThreadPoolBulkhead bulkhead) {
            this.threadPoolBulkheads.put(bulkhead.getName(), bulkhead);
            return this;
        }

        public Builder andRetry(Retry retry) {
            this.retries.put(retry.getName(), retry);
            return this;
        }

        public Builder andTimeLimiter(TimeLimiter timeLimiter) {
            this.timeLimiters.put(timeLimiter.getName(), timeLimiter);
            return this;
        }

        public Builder withCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
            this.circuitBreakerRegistry = circuitBreakerRegistry;
            return this;
        }

        public Builder withBulkheadRegistry(BulkheadRegistry bulkheadRegistry) {
            this.bulkheadRegistry = bulkheadRegistry;
            return this;
        }

        public Builder withThreadPoolBulkheadRegistry(ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry) {
            this.threadPoolBulkheadRegistry = threadPoolBulkheadRegistry;
            return this;
        }

        public Builder withRetryRegistry(RetryRegistry registry) {
            this.retryRegistry = registry;
            return this;
        }

        public Builder withTimeLimiterRegistry(TimeLimiterRegistry timeLimiterRegistry) {
            this.timeLimiterRegistry = timeLimiterRegistry;
            return this;
        }

        public Builder withTimerRegistry(TimerRegistry registry) {
            this.timerRegistry = registry;
            return this;
        }

        public Resilience4jMetricsStreamServlet build() {
            Observable commandObservable = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).map(i -> {
                HashMap<String, CircuitBreaker> circuitBreakerMap = new HashMap<String, CircuitBreaker>(this.circuitBreakers);
                for (CircuitBreaker circuitBreaker : this.circuitBreakerRegistry.getAllCircuitBreakers()) {
                    circuitBreakerMap.put(circuitBreaker.getName(), circuitBreaker);
                }
                HashMap<String, Bulkhead> bulkheadMap = new HashMap<String, Bulkhead>(this.bulkheads);
                for (Bulkhead bulkhead : this.bulkheadRegistry.getAllBulkheads()) {
                    bulkheadMap.put(bulkhead.getName(), bulkhead);
                }
                HashMap<String, ThreadPoolBulkhead> threadPoolBulkheadMap = new HashMap<String, ThreadPoolBulkhead>(this.threadPoolBulkheads);
                for (ThreadPoolBulkhead threadPoolBulkhead : this.threadPoolBulkheadRegistry.getAllBulkheads()) {
                    threadPoolBulkheadMap.put(threadPoolBulkhead.getName(), threadPoolBulkhead);
                }
                HashMap<String, Retry> retryMap = new HashMap<String, Retry>(this.retries);
                for (Retry retry : this.retryRegistry.getAllRetries()) {
                    retryMap.put(retry.getName(), retry);
                }
                HashMap<String, TimeLimiter> timeLimiterMap = new HashMap<String, TimeLimiter>(this.timeLimiters);
                for (TimeLimiter timeLimiter : this.timeLimiterRegistry.getAllTimeLimiters()) {
                    timeLimiterMap.put(timeLimiter.getName(), timeLimiter);
                }
                HashMap clientTimerMap = new HashMap();
                HashMap serverTimerMap = new HashMap();
                Map allTimers = this.timerRegistry.getAllTimers();
                for (String timerName : allTimers.keySet()) {
                    String s;
                    String[] split;
                    if (timerName.endsWith(".client")) {
                        split = timerName.split(".client");
                        s = split[0];
                        clientTimerMap.put(s, allTimers.get(timerName));
                    }
                    if (!timerName.endsWith(".server")) continue;
                    split = timerName.split(".server");
                    s = split[0];
                    serverTimerMap.put(s, allTimers.get(timerName));
                }
                HashSet<String> keySet = new HashSet<String>();
                keySet.addAll(circuitBreakerMap.keySet());
                keySet.addAll(bulkheadMap.keySet());
                keySet.addAll(threadPoolBulkheadMap.keySet());
                keySet.addAll(retryMap.keySet());
                keySet.addAll(clientTimerMap.keySet());
                keySet.addAll(serverTimerMap.keySet());
                keySet.addAll(timeLimiterMap.keySet());
                Stream<HystrixCommandLikeMetrics> hystrixCommandLikeMetricsStream = keySet.stream().map(key -> new HystrixCommandLikeMetrics((String)key, (CircuitBreaker)circuitBreakerMap.get(key), (Bulkhead)bulkheadMap.get(key), (ThreadPoolBulkhead)threadPoolBulkheadMap.get(key), (Retry)retryMap.get(key), (TimeLimiter)timeLimiterMap.get(key), (Timer)clientTimerMap.get(key), (Timer)serverTimerMap.get(key)));
                Stream<HystrixThreadPoolLikeMetrics> hystrixThreadPoolLikeMetricsStream = threadPoolBulkheadMap.keySet().stream().map(key -> new HystrixThreadPoolLikeMetrics((String)key, (ThreadPoolBulkhead)threadPoolBulkheadMap.get(key), (CircuitBreaker)circuitBreakerMap.get(key)));
                return Stream.concat(hystrixCommandLikeMetricsStream, hystrixThreadPoolLikeMetricsStream).collect(Collectors.toList());
            });
            Observable commandObservableMap = commandObservable.flatMap(Observable::from);
            Observable serializedCommandObservable = commandObservableMap.map(m -> {
                try {
                    return this.objectMapper.writeValueAsString(m);
                }
                catch (Exception e) {
                    LOGGER.warn("Error in resilience.stream", (Throwable)e);
                    return "";
                }
            });
            Observable hystrixObservable = HystrixDashboardStream.getInstance().observe().concatMap(dashboardData -> Observable.from((Iterable)SerialHystrixDashboardData.toMultipleJsonStrings((HystrixDashboardStream.DashboardData)dashboardData)));
            Observable finalObservable = serializedCommandObservable.mergeWith(hystrixObservable).share().onBackpressureDrop();
            return new Resilience4jMetricsStreamServlet((Observable<String>)finalObservable);
        }
    }
}

