/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilience4all.metrics.eventstream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.flipkart.resilience4all.metrics.eventstream.HystrixMetrics;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.util.Objects;
import rx.exceptions.OnErrorNotImplementedException;

public class HystrixThreadPoolLikeMetrics
implements HystrixMetrics {
    @JsonIgnore
    private final ThreadPoolBulkhead threadPoolBulkhead;
    @JsonIgnore
    private final CircuitBreaker circuitBreaker;

    public HystrixThreadPoolLikeMetrics(String commandName, ThreadPoolBulkhead threadPoolBulkhead, CircuitBreaker circuitBreaker) {
        if (Objects.isNull(threadPoolBulkhead)) {
            throw new OnErrorNotImplementedException("Please provide threadpoolbulkhead for: " + commandName, (Throwable)new IllegalArgumentException(commandName));
        }
        this.threadPoolBulkhead = threadPoolBulkhead;
        this.circuitBreaker = circuitBreaker;
    }

    @Override
    public String getType() {
        return "HystrixThreadPool";
    }

    @Override
    public String getName() {
        if (Objects.nonNull(this.threadPoolBulkhead)) {
            return this.threadPoolBulkhead.getName();
        }
        throw new IllegalStateException("resilience4j object can not be null.");
    }

    public Number getCurrentActiveCount() {
        return 0;
    }

    public Number getCurrentCompletedTaskCount() {
        return 0;
    }

    public Number getCurrentCorePoolSize() {
        return this.threadPoolBulkhead.getMetrics().getCoreThreadPoolSize();
    }

    public Number getCurrentLargestPoolSize() {
        return 0;
    }

    public Number getCurrentMaximumPoolSize() {
        return this.threadPoolBulkhead.getMetrics().getMaximumThreadPoolSize();
    }

    public Number getCurrentPoolSize() {
        return this.threadPoolBulkhead.getMetrics().getThreadPoolSize();
    }

    public Number getCurrentTaskCount() {
        return 0;
    }

    public Number getCurrentQueueSize() {
        int max = this.threadPoolBulkhead.getMetrics().getQueueCapacity();
        int available = this.threadPoolBulkhead.getMetrics().getRemainingQueueCapacity();
        return max - available;
    }

    public Number getRollingCountThreadsExecuted() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getMetrics().getNumberOfBufferedCalls();
        }
        return 0;
    }

    public Number getRollingMaxActiveThreads() {
        return this.threadPoolBulkhead.getMetrics().getThreadPoolSize();
    }

    public Number getRollingCountCommandRejections() {
        return 0;
    }

    public Number getPropertyValue_queueSizeRejectionThreshold() {
        return this.threadPoolBulkhead.getMetrics().getQueueCapacity();
    }

    public Number getPropertyValue_metricsRollingStatisticalWindowInMilliseconds() {
        return 0;
    }

    public Number getReportingHosts() {
        return 1;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

