/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.weight;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.common.naming.TopicName;

public class WeightedConsumerConfiguration {
    public static String WT_CONF_PREFIX = "WT_";
    public static String WT_TOPIC_CONF_PREFIX = "WTP_";
    private DistributionStrategy distributionStrategy = DistributionStrategy.LINEAR;
    private int minBound = 100;
    private int maxBound = 1000;
    private Map<String, Integer> topicWeights = new HashMap<String, Integer>();
    private boolean throttleReceiveQueue = false;
    private int queueResumeThreshold = 0;
    private int maxWeightAllowed = 100;

    public void setDistributionStrategy(DistributionStrategy distributionStrategy) {
        this.distributionStrategy = distributionStrategy;
    }

    public void setMinBound(int minBound) {
        this.minBound = minBound;
    }

    public void setMaxBound(int maxBound) {
        this.maxBound = maxBound;
    }

    public void addTopic(String topic, Integer weight) {
        Preconditions.checkNotNull((Object)topic);
        if (weight == null && (weight = WeightedConsumerConfiguration.parseWeightFromTopic(topic)) == null) {
            weight = 1;
        }
        this.topicWeights.put(topic, weight);
    }

    public void setThrottleReceiveQueue(boolean shouldThrottle) {
        this.throttleReceiveQueue = shouldThrottle;
    }

    public void setQueueResumeThreshold(int queueResumeThreshold) {
        this.queueResumeThreshold = queueResumeThreshold;
    }

    public void setMaxWeightAllowed(int maxWeight) {
        this.maxWeightAllowed = maxWeight;
    }

    public DistributionStrategy getDistributionStrategy() {
        return this.distributionStrategy;
    }

    public int getMinBound() {
        return this.minBound;
    }

    public int getMaxBound() {
        return this.maxBound;
    }

    public Map<String, Integer> getTopicWeights() {
        return Collections.unmodifiableMap(this.topicWeights);
    }

    public boolean isThrottleReceiveQueue() {
        return this.throttleReceiveQueue;
    }

    public int getQueueResumeThreshold() {
        return this.queueResumeThreshold;
    }

    public int getMaxWeightAllowed() {
        return this.maxWeightAllowed;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Weight configuration:");
        str.append(" dist_strategy=").append((Object)this.distributionStrategy);
        str.append(" min_bound=").append(this.minBound);
        str.append(" max_bound=").append(this.maxBound);
        str.append(" max_weight_allowed=").append(this.maxWeightAllowed);
        str.append(" throttle_recv_queue=").append(this.throttleReceiveQueue);
        str.append(" queue_resume_threshold=").append(this.queueResumeThreshold);
        str.append(" topic_weights=[");
        this.topicWeights.forEach((topic, weight) -> str.append(" {").append((String)topic).append(", ").append(weight).append("}"));
        str.append(" ]");
        return str.toString();
    }

    private void validate() {
        Preconditions.checkArgument((this.maxWeightAllowed >= 1 ? 1 : 0) != 0, (Object)"max weight allowed should be equal or more than 1");
        Preconditions.checkArgument((this.minBound >= 100 ? 1 : 0) != 0, (Object)"min bound should be at least 100");
        Preconditions.checkArgument((this.maxBound >= this.minBound ? 1 : 0) != 0, (String)"max bound should be at least as much as min bound %s", (int)this.minBound);
        Preconditions.checkArgument((this.queueResumeThreshold >= 0 && this.queueResumeThreshold <= this.minBound ? 1 : 0) != 0, (String)"queue resume threshold should be in the range [0,minBound(%s)]", (int)this.minBound);
        if (this.topicWeights.size() > 0) {
            for (Map.Entry<String, Integer> entry : this.topicWeights.entrySet()) {
                Integer weight = entry.getValue();
                Preconditions.checkNotNull((Object)weight);
                Preconditions.checkArgument((weight >= 1 && weight <= this.maxWeightAllowed ? 1 : 0) != 0, (String)"non-null weights should be in the range [1,maxWeightAllowed(%s)], found %s for topic %s", (Object)this.maxWeightAllowed, (Object)weight.toString(), (Object)entry.getKey());
            }
        }
    }

    public <T> void populateBuilder(ConsumerBuilder<T> builder) {
        this.validate();
        WeightedConsumerConfiguration.addProp(builder, "DIST_STRATEGY", (Object)this.distributionStrategy);
        WeightedConsumerConfiguration.addProp(builder, "MIN_BOUND", this.minBound);
        WeightedConsumerConfiguration.addProp(builder, "MAX_BOUND", this.maxBound);
        WeightedConsumerConfiguration.addProp(builder, "THROTTLE_RQ", this.throttleReceiveQueue);
        WeightedConsumerConfiguration.addProp(builder, "RESUME_THRESHOLD", this.queueResumeThreshold);
        WeightedConsumerConfiguration.addProp(builder, "MAX_WT_ALLOWED", this.maxWeightAllowed);
        this.topicWeights.forEach((topic, weight) -> WeightedConsumerConfiguration.populateTopicInBuilder(builder, topic, weight));
    }

    public static <T> void populateTopicInBuilder(ConsumerBuilder<T> builder, String topic, Integer weight) {
        builder.topic(new String[]{topic});
        builder.property(WT_TOPIC_CONF_PREFIX + topic, weight == null ? "" : weight.toString());
    }

    public static <T> WeightedConsumerConfiguration loadFromConf(ConsumerConfigurationData<T> conf) {
        WeightedConsumerConfiguration weightConf = new WeightedConsumerConfiguration();
        weightConf.setDistributionStrategy(DistributionStrategy.valueOf(WeightedConsumerConfiguration.readPropOrDefault(conf, "DIST_STRATEGY", DistributionStrategy.LINEAR.name())));
        weightConf.setMinBound(WeightedConsumerConfiguration.parseConfAsIntOrDefault(conf, "MIN_BOUND", 100));
        weightConf.setMaxBound(WeightedConsumerConfiguration.parseConfAsIntOrDefault(conf, "MAX_BOUND", 1000));
        weightConf.setThrottleReceiveQueue(Boolean.parseBoolean(WeightedConsumerConfiguration.readPropOrDefault(conf, "THROTTLE_RQ", "false")));
        weightConf.setQueueResumeThreshold(WeightedConsumerConfiguration.parseConfAsIntOrDefault(conf, "RESUME_THRESHOLD", 0));
        weightConf.setMaxWeightAllowed(WeightedConsumerConfiguration.parseConfAsIntOrDefault(conf, "MAX_WT_ALLOWED", 100));
        SortedMap props = conf.getProperties();
        for (String confKey : props.tailMap(WT_TOPIC_CONF_PREFIX).keySet()) {
            Integer weight;
            if (!confKey.startsWith(WT_TOPIC_CONF_PREFIX)) continue;
            String topic = confKey.split(WT_TOPIC_CONF_PREFIX)[1];
            try {
                weight = Integer.parseInt((String)conf.getProperties().get(confKey));
            }
            catch (NumberFormatException ex) {
                weight = null;
            }
            weightConf.addTopic(topic, weight);
        }
        weightConf.validate();
        return weightConf;
    }

    private static <T> void addProp(ConsumerBuilder<T> builder, String key, Object val) {
        builder.property(WT_CONF_PREFIX + key, val.toString());
    }

    private static <T> String readPropOrDefault(ConsumerConfigurationData<T> conf, String key, String defaultVal) {
        String val = (String)conf.getProperties().get(WT_CONF_PREFIX + key);
        return val != null ? val : defaultVal;
    }

    private static <T> Integer parseConfAsIntOrDefault(ConsumerConfigurationData<T> conf, String key, Integer defaultVal) {
        try {
            return Integer.parseInt(WeightedConsumerConfiguration.readPropOrDefault(conf, key, defaultVal != null ? defaultVal.toString() : null));
        }
        catch (NumberFormatException ex) {
            return defaultVal;
        }
    }

    private static Integer parseWeightFromTopic(String topic) {
        String[] parts;
        TopicName topicName = TopicName.get((String)topic);
        if (topicName.isPartitioned()) {
            topic = topicName.getPartitionedTopicName();
        }
        if ((parts = topic.split("-weight-")).length == 2) {
            try {
                return Integer.valueOf(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static enum DistributionStrategy {
        LINEAR,
        EXPONENTIAL;

    }
}

