/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.weight;

import java.util.Map;
import org.apache.pulsar.client.impl.weight.ExponentialWeightDistribution;
import org.apache.pulsar.client.impl.weight.LinearWeightDistribution;
import org.apache.pulsar.client.impl.weight.RangeDistribution;
import org.apache.pulsar.client.impl.weight.TopicThresholdDistribution;
import org.apache.pulsar.client.impl.weight.WeightDistribution;
import org.apache.pulsar.client.impl.weight.WeightedConsumerConfiguration;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicThresholdDistributionImpl
implements TopicThresholdDistribution {
    private static final Logger log = LoggerFactory.getLogger(TopicThresholdDistributionImpl.class);
    private final WeightDistribution distribution;
    private final Map<String, Integer> topicWeights;

    private TopicThresholdDistributionImpl(Map<String, Integer> topicWeights, WeightDistribution distribution) {
        this.topicWeights = topicWeights;
        this.distribution = distribution;
    }

    @Override
    public int getWeight(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        Integer weight = this.topicWeights.get(topic);
        if (weight == null && topicName.isPartitioned()) {
            weight = this.topicWeights.get(topicName.getPartitionedTopicName());
        }
        if (weight == null) {
            log.warn("Weight not found for topic={}, default to weight=1", (Object)topic);
            weight = 1;
        }
        return weight;
    }

    @Override
    public int getMinValue() {
        return this.distribution.getMinValue();
    }

    @Override
    public int getMaxValue() {
        return this.distribution.getMaxValue();
    }

    @Override
    public int getValue(String topic) {
        int bound = this.distribution.getValue(this.getWeight(topic));
        log.debug("Topic threshold for topic={} is {}", (Object)topic, (Object)bound);
        return bound;
    }

    public static <T> TopicThresholdDistribution loadFromConf(WeightedConsumerConfiguration conf) throws IllegalArgumentException {
        RangeDistribution weightDistribution;
        int maxWeight = 1;
        for (Map.Entry<String, Integer> entry : conf.getTopicWeights().entrySet()) {
            maxWeight = Math.max(maxWeight, entry.getValue());
        }
        switch (conf.getDistributionStrategy()) {
            case LINEAR: {
                weightDistribution = new LinearWeightDistribution(conf.getMinBound(), conf.getMaxBound(), maxWeight);
                break;
            }
            case EXPONENTIAL: {
                weightDistribution = new ExponentialWeightDistribution(conf.getMinBound(), conf.getMaxBound(), maxWeight);
                break;
            }
            default: {
                throw new IllegalArgumentException("Weight strategy " + (Object)((Object)conf.getDistributionStrategy()) + " is not supported");
            }
        }
        return new TopicThresholdDistributionImpl(conf.getTopicWeights(), weightDistribution);
    }
}

