/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.weight;

import org.apache.pulsar.client.impl.weight.RangeDistribution;

public class ExponentialWeightDistribution
extends RangeDistribution {
    public ExponentialWeightDistribution(int lowerBound, int upperBound, int points) {
        super(lowerBound, upperBound, points);
    }

    @Override
    protected int[] distribute(int lowerBound, int upperBound, int points) {
        if (points == 1) {
            return new int[]{lowerBound};
        }
        if (points == 2) {
            return new int[]{lowerBound, upperBound};
        }
        int[] distribution = new int[points];
        double multiplier = Math.pow((double)upperBound * 1.0 / (double)lowerBound, 1.0 / (double)(points - 1));
        for (int i = 0; i < points; ++i) {
            distribution[i] = i == points - 1 ? upperBound : (int)Math.round((double)lowerBound * Math.pow(multiplier, i));
        }
        return distribution;
    }

    @Override
    public String getName() {
        return "EXPONENTIAL";
    }
}

