/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.weight;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.Message;

public class TopicMessageCountTracker
implements Collection<Message> {
    Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();

    public Map<String, Integer> getCounters() {
        Map<String, Integer> ret = this.counters.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AtomicInteger)e.getValue()).get()));
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public boolean add(Message m) {
        this.counters.computeIfAbsent(m.getTopicName(), k -> new AtomicInteger());
        this.counters.get(m.getTopicName()).incrementAndGet();
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Message> c) {
        c.stream().forEach(m -> this.add((Message)m));
        return true;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Message> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.counters.clear();
    }
}

