/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.weight;

import org.apache.pulsar.client.impl.weight.WeightDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangeDistribution
implements WeightDistribution {
    private static final Logger log = LoggerFactory.getLogger(RangeDistribution.class);
    private final int[] distribution;

    public RangeDistribution(int lowerBound, int upperBound, int maxWeight) {
        this.validate(lowerBound, upperBound, maxWeight);
        this.distribution = this.distribute(lowerBound, upperBound, maxWeight);
        if (this.distribution == null) {
            throw new IllegalArgumentException("Null distribution generated in the strategy=" + this.getName());
        }
        log.info("Distribution for strategy={}: {}", (Object)this.getName(), (Object)this.distributionToString());
    }

    @Override
    public int getValue(int weight) {
        if (weight <= 0 || weight > this.distribution.length) {
            throw new IllegalArgumentException("Invalid weight=" + weight + " supplied");
        }
        return this.distribution[weight - 1];
    }

    @Override
    public int getMinValue() {
        return this.distribution[0];
    }

    @Override
    public int getMaxValue() {
        return this.distribution[this.distribution.length - 1];
    }

    public String toString() {
        return String.format("name=%s, distribution=%s", this.getName(), this.distributionToString());
    }

    protected abstract int[] distribute(int var1, int var2, int var3);

    protected void validate(int lowerBound, int upperBound, int points) {
        if (lowerBound < 1) {
            throw new IllegalArgumentException("Min for lower bound is 1, provided=" + lowerBound);
        }
        if (points <= 0) {
            throw new IllegalArgumentException("Points should be greater than zero, provided=" + points);
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException(String.format("Upper bound should be greater than or equal to lower bound=%d, provided=%d", lowerBound, upperBound));
        }
    }

    private String distributionToString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.distribution.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.distribution[i]);
        }
        return builder.toString();
    }
}

