/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.ConsumerStatsRecorder;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.MessagesImpl;
import org.apache.pulsar.client.impl.MultiMessageIdImpl;
import org.apache.pulsar.client.impl.PartitionsChangedListener;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.UnAckedTopicMessageTracker;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.impl.weight.TopicMessageCountTracker;
import org.apache.pulsar.client.impl.weight.TopicThresholdDistribution;
import org.apache.pulsar.client.impl.weight.TopicThresholdDistributionImpl;
import org.apache.pulsar.client.impl.weight.WeightedConsumerConfiguration;
import org.apache.pulsar.client.util.ConsumerName;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.CompletableFutureCancellationHandler;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.io.netty.util.TimerTask;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedMultiTopicsConsumerImpl<T>
extends ConsumerBase<T> {
    public static final String DUMMY_TOPIC_NAME_PREFIX = "WeightedMultiConsumerImpl-";
    private static final Logger log = LoggerFactory.getLogger(WeightedMultiTopicsConsumerImpl.class);
    protected final ConcurrentHashMap<String, Integer> partitionedTopics;
    private final ConcurrentHashMap<String, ConsumerImpl<T>> consumers;
    private final ConcurrentLinkedQueue<ConsumerImpl<T>> pausedConsumers;
    private final int sharedQueueResumeThreshold;
    private final boolean throttleReceiverQueue;
    private final TopicThresholdDistribution topicThresholdDistribution;
    private final ConcurrentHashMap<String, AtomicInteger> messageCounters = new ConcurrentHashMap();
    private final Object pauseMutex = new Object();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConsumerStatsRecorder stats;
    private final UnAckedMessageTracker unAckedMessageTracker;
    private final ConsumerConfigurationData<T> internalConfig;
    private final long startMessageRollbackDurationInSec;
    AtomicInteger allTopicPartitionsNumber;
    TopicsPartitionChangedListener topicsPartitionChangedListener;
    CompletableFuture<Void> partitionsAutoUpdateFuture = null;
    private boolean paused = false;
    private volatile Timeout partitionsAutoUpdateTimeout = null;
    private volatile BatchMessageIdImpl startMessageId = null;
    private final TimerTask partitionsAutoUpdateTimerTask = new TimerTask(){

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled() || WeightedMultiTopicsConsumerImpl.this.getState() != HandlerState.State.Ready) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] run partitionsAutoUpdateTimerTask", (Object)WeightedMultiTopicsConsumerImpl.this.topic);
            }
            if (WeightedMultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture == null || WeightedMultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture.isDone()) {
                WeightedMultiTopicsConsumerImpl.this.partitionsAutoUpdateFuture = WeightedMultiTopicsConsumerImpl.this.topicsPartitionChangedListener.onTopicsExtended(WeightedMultiTopicsConsumerImpl.this.partitionedTopics.keySet());
            }
            WeightedMultiTopicsConsumerImpl.this.partitionsAutoUpdateTimeout = WeightedMultiTopicsConsumerImpl.this.client.timer().newTimeout(WeightedMultiTopicsConsumerImpl.this.partitionsAutoUpdateTimerTask, WeightedMultiTopicsConsumerImpl.this.conf.getAutoUpdatePartitionsIntervalSeconds(), TimeUnit.SECONDS);
        }
    };

    WeightedMultiTopicsConsumerImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        this(client, DUMMY_TOPIC_NAME_PREFIX + ConsumerName.generateRandomName(), conf, executorProvider, subscribeFuture, schema, interceptors, createTopicIfDoesNotExist);
    }

    WeightedMultiTopicsConsumerImpl(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist, MessageId startMessageId, long startMessageRollbackDurationInSec) {
        this(client, DUMMY_TOPIC_NAME_PREFIX + ConsumerName.generateRandomName(), conf, executorProvider, subscribeFuture, schema, interceptors, createTopicIfDoesNotExist, startMessageId, startMessageRollbackDurationInSec);
    }

    WeightedMultiTopicsConsumerImpl(PulsarClientImpl client, String singleTopic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        this(client, singleTopic, conf, executorProvider, subscribeFuture, schema, interceptors, createTopicIfDoesNotExist, null, 0L);
    }

    WeightedMultiTopicsConsumerImpl(PulsarClientImpl client, String singleTopic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist, MessageId startMessageId, long startMessageRollbackDurationInSec) {
        super(client, singleTopic, conf, Math.max(2, conf.getReceiverQueueSize()), executorProvider, subscribeFuture, schema, interceptors);
        Preconditions.checkArgument((conf.getReceiverQueueSize() > 0 ? 1 : 0) != 0, (Object)"Receiver queue size needs to be greater than 0 for Topics Consumer");
        log.info("Receive queue for multi consumer {}", (Object)this.maxReceiverQueueSize);
        this.partitionedTopics = new ConcurrentHashMap();
        this.consumers = new ConcurrentHashMap();
        this.pausedConsumers = new ConcurrentLinkedQueue();
        this.allTopicPartitionsNumber = new AtomicInteger(0);
        this.startMessageId = startMessageId != null ? new BatchMessageIdImpl(MessageIdImpl.convertToMessageIdImpl((MessageId)startMessageId)) : null;
        this.startMessageRollbackDurationInSec = startMessageRollbackDurationInSec;
        WeightedConsumerConfiguration weightConf = WeightedConsumerConfiguration.loadFromConf(conf);
        log.info("{}", (Object)weightConf);
        this.topicThresholdDistribution = TopicThresholdDistributionImpl.loadFromConf(weightConf);
        this.sharedQueueResumeThreshold = Math.max(0, Math.min(this.topicThresholdDistribution.getMinValue(), weightConf.getQueueResumeThreshold()));
        this.throttleReceiverQueue = weightConf.isThrottleReceiveQueue();
        this.unAckedMessageTracker = conf.getAckTimeoutMillis() != 0L ? (conf.getTickDurationMillis() > 0L ? new UnAckedTopicMessageTracker(client, (ConsumerBase)this, conf) : new UnAckedTopicMessageTracker(client, (ConsumerBase)this, conf)) : UnAckedMessageTracker.UNACKED_MESSAGE_TRACKER_DISABLED;
        this.internalConfig = this.getInternalConsumerConfig();
        ConsumerStatsRecorderImpl consumerStatsRecorderImpl = this.stats = client.getConfiguration().getStatsIntervalSeconds() > 0L ? new ConsumerStatsRecorderImpl((Consumer)this) : null;
        if (conf.isAutoUpdatePartitions()) {
            this.topicsPartitionChangedListener = new TopicsPartitionChangedListener();
            this.partitionsAutoUpdateTimeout = client.timer().newTimeout(this.partitionsAutoUpdateTimerTask, conf.getAutoUpdatePartitionsIntervalSeconds(), TimeUnit.SECONDS);
        }
        if (conf.getTopicNames().isEmpty()) {
            this.setState(HandlerState.State.Ready);
            this.subscribeFuture().complete(this);
            return;
        }
        Preconditions.checkArgument((conf.getTopicNames().isEmpty() || WeightedMultiTopicsConsumerImpl.topicNamesValid(conf.getTopicNames()) ? 1 : 0) != 0, (Object)"Topics is empty or invalid.");
        List futures = conf.getTopicNames().stream().map(t -> this.subscribeAsync((String)t, createTopicIfDoesNotExist)).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futures).thenAccept(finalFuture -> {
            if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
            }
            this.setState(HandlerState.State.Ready);
            this.startReceivingMessages(new ArrayList<ConsumerImpl<T>>(this.consumers.values()));
            log.info("[{}] [{}] Created topics consumer with {} sub-consumers", new Object[]{this.topic, this.subscription, this.allTopicPartitionsNumber.get()});
            this.subscribeFuture().complete(this);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to subscribe topics: {}, closing consumer", (Object)this.topic, (Object)ex.getMessage());
            this.closeAsync().whenComplete((res, closeEx) -> {
                if (closeEx != null) {
                    log.error("[{}] Failed to unsubscribe after failed consumer creation: {}", (Object)this.topic, (Object)closeEx.getMessage());
                }
                subscribeFuture.completeExceptionally((Throwable)ex);
            });
            return null;
        });
    }

    private static boolean topicNamesValid(Collection<String> topics) {
        Preconditions.checkState((topics != null && topics.size() >= 1 ? 1 : 0) != 0, (Object)"topics should contain more than 1 topic");
        Optional<String> result = topics.stream().filter(topic -> !TopicName.isValid((String)topic)).findFirst();
        if (result.isPresent()) {
            log.warn("Received invalid topic name: {}", (Object)result.get());
            return false;
        }
        HashSet<String> set = new HashSet<String>(topics);
        if (set.size() == topics.size()) {
            return true;
        }
        log.warn("Topic names not unique. unique/all : {}/{}", (Object)set.size(), (Object)topics.size());
        return false;
    }

    public static <T> WeightedMultiTopicsConsumerImpl<T> createPartitionedConsumer(PulsarClientImpl client, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> subscribeFuture, int numPartitions, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        Preconditions.checkArgument((conf.getTopicNames().size() == 1 ? 1 : 0) != 0, (Object)"Should have only 1 topic for partitioned consumer");
        ConsumerConfigurationData cloneConf = conf.clone();
        String topicName = cloneConf.getSingleTopic();
        cloneConf.getTopicNames().remove(topicName);
        CompletableFuture<Consumer<T>> future = new CompletableFuture<Consumer<T>>();
        WeightedMultiTopicsConsumerImpl consumer = new WeightedMultiTopicsConsumerImpl(client, topicName, cloneConf, executorProvider, future, schema, interceptors, true);
        ((CompletableFuture)((CompletableFuture)future.thenCompose(c -> ((WeightedMultiTopicsConsumerImpl)((Object)c)).subscribeAsync(topicName, numPartitions))).thenRun(() -> subscribeFuture.complete((Consumer)consumer))).exceptionally(e -> {
            log.warn("Failed subscription for createPartitionedConsumer: {} {}, e:{}", new Object[]{topicName, numPartitions, e});
            consumer.cleanupMultiConsumer();
            subscribeFuture.completeExceptionally(PulsarClientException.wrap((Throwable)((Throwable)e).getCause(), (String)String.format("Failed to subscribe %s with %d partitions", topicName, numPartitions)));
            return null;
        });
        return consumer;
    }

    public static boolean isIllegalMultiTopicsMessageId(MessageId messageId) {
        return !MessageId.earliest.equals(messageId) && !MessageId.latest.equals(messageId);
    }

    public static <T> CompletableFuture<Consumer<T>> subscribeAsync(PulsarClient client, ConsumerConfigurationData<T> conf, WeightedConsumerConfiguration weightConf, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        if (!(client instanceof PulsarClientImpl)) {
            return FutureUtil.failedFuture((Throwable)new IllegalArgumentException("Expected pulsar client to be of type: " + PulsarClientImpl.class.getName()));
        }
        PulsarClientImpl clientImpl = (PulsarClientImpl)client;
        AtomicReference state = clientImpl.getState();
        Set internalClientConsumers = null;
        try {
            Field consumersField = clientImpl.getClass().getDeclaredField("consumers");
            consumersField.setAccessible(true);
            internalClientConsumers = (Set)consumersField.get(clientImpl);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            log.debug("Cannot retrieve internal consumers of the pulsar client, fatal failure");
            return FutureUtil.failedFuture((Throwable)new PulsarClientException("Cannot retrieve internal consumers of the pulsar client, fatal failure", (Throwable)ex));
        }
        if (state.get() != PulsarClientImpl.State.Open) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Client already closed"));
        }
        if (conf == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Consumer configuration undefined"));
        }
        for (String topic2 : conf.getTopicNames()) {
            if (TopicName.isValid((String)topic2)) continue;
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidTopicNameException("Invalid topic name: '" + topic2 + "'"));
        }
        if (StringUtils.isBlank((CharSequence)conf.getSubscriptionName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Empty subscription name"));
        }
        if (conf.isReadCompacted() && (!conf.getTopicNames().stream().allMatch(topic -> TopicName.get((String)topic).getDomain() == TopicDomain.persistent) || conf.getSubscriptionType() != SubscriptionType.Exclusive && conf.getSubscriptionType() != SubscriptionType.Failover)) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Read compacted can only be used with exclusive or failover persistent subscriptions"));
        }
        if (conf.getConsumerEventListener() != null && conf.getSubscriptionType() != SubscriptionType.Failover) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Active consumer listener is only supported for failover subscription"));
        }
        conf.setReceiverQueueSize(weightConf.getMaxBound());
        if (conf.getTopicsPattern() != null) {
            return FutureUtil.failedFuture((Throwable)new IllegalArgumentException("Topics pattern not supported in weighted consumer"));
        }
        CompletableFuture<Consumer<T>> consumerSubscribedFuture = new CompletableFuture<Consumer<T>>();
        WeightedMultiTopicsConsumerImpl<T> consumer = new WeightedMultiTopicsConsumerImpl<T>(clientImpl, conf, clientImpl.externalExecutorProvider(), consumerSubscribedFuture, schema, interceptors, true);
        internalClientConsumers.add(consumer);
        return consumerSubscribedFuture;
    }

    private static String partitionTopic(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        if (topicName.isPartitioned()) {
            topic = topicName.getPartitionedTopicName();
        }
        return topic;
    }

    private void startReceivingMessages(List<ConsumerImpl<T>> newConsumers) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] startReceivingMessages for {} new consumers in topics consumer, state: {}", new Object[]{this.topic, newConsumers.size(), this.getState()});
        }
        if (this.getState() == HandlerState.State.Ready) {
            newConsumers.forEach(consumer -> {
                int permits = this.getReceiverQueueSize(consumer.getTopic());
                if (log.isDebugEnabled()) {
                    log.debug("Increasing permits of consumer for topic {} by {}", (Object)consumer.getTopic(), (Object)permits);
                }
                consumer.increaseAvailablePermits(consumer.getConnectionHandler().cnx(), permits);
                this.internalPinnedExecutor.execute(() -> this.receiveMessageFromConsumer((ConsumerImpl<T>)consumer));
            });
        }
    }

    private void receiveMessageFromConsumer(ConsumerImpl<T> consumer) {
        consumer.receiveAsync().thenAccept(message -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Receive message from sub consumer:{}", new Object[]{this.topic, this.subscription, consumer.getTopic()});
            }
            this.messageReceived(consumer, (Message<T>)message);
            String partitionTopic = WeightedMultiTopicsConsumerImpl.partitionTopic(consumer.getTopic());
            int threshold = this.topicThresholdDistribution.getValue(partitionTopic);
            int messagesInQueue = this.messageCounters.get(partitionTopic).get();
            if (messagesInQueue > threshold) {
                this.pausedConsumers.add(consumer);
                if (log.isDebugEnabled()) {
                    log.debug("Consumer {} paused with state {}/{} and total={}", new Object[]{this.topic, messagesInQueue, threshold, this.incomingMessages.size()});
                }
                this.resumeReceivingFromPausedConsumersIfNeeded();
            } else {
                this.internalPinnedExecutor.execute(() -> this.receiveMessageFromConsumer(consumer));
            }
        });
    }

    private void messageReceived(ConsumerImpl<T> consumer, Message<T> message) {
        CompletableFuture receivedFuture;
        Preconditions.checkArgument((boolean)(message instanceof MessageImpl));
        TopicMessageImpl topicMessage = new TopicMessageImpl(consumer.getTopic(), consumer.getTopicNameWithoutPartition(), message, consumer);
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Received message from topics-consumer {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
        }
        if ((receivedFuture = this.nextPendingReceive()) != null) {
            this.unAckedMessageTracker.add(topicMessage.getMessageId());
            this.completePendingReceive(receivedFuture, (Message)topicMessage);
        } else if (this.enqueueMessageAndCheckBatchReceive((Message<T>)topicMessage) && this.hasPendingBatchReceive()) {
            this.notifyPendingBatchReceivedCallBack();
        }
        if (this.listener != null) {
            this.triggerListener();
        }
    }

    protected synchronized void messageProcessed(Message<?> msg) {
        this.unAckedMessageTracker.add(msg.getMessageId());
        this.decreaseIncomingMessageSize(msg);
    }

    private void resumeReceivingFromPausedConsumersIfNeeded() {
        if (this.incomingMessages.size() <= this.sharedQueueResumeThreshold && !this.pausedConsumers.isEmpty()) {
            ConsumerImpl<T> consumer;
            while ((consumer = this.pausedConsumers.poll()) != null) {
                this.internalPinnedExecutor.execute(() -> this.receiveMessageFromConsumer(consumer));
            }
        }
    }

    protected boolean enqueueMessageAndCheckBatchReceive(Message<T> message) {
        Boolean val = super.enqueueMessageAndCheckBatchReceive(message);
        this.messageCounters.get(WeightedMultiTopicsConsumerImpl.partitionTopic(message.getTopicName())).incrementAndGet();
        return val;
    }

    protected void decreaseIncomingMessageSize(Message<?> message) {
        super.decreaseIncomingMessageSize(message);
        this.messageCounters.get(WeightedMultiTopicsConsumerImpl.partitionTopic(message.getTopicName())).decrementAndGet();
    }

    protected void resetIncomingMessageSize() {
        super.resetIncomingMessageSize();
        TopicMessageCountTracker topicMessageCountTracker = new TopicMessageCountTracker();
        this.incomingMessages.drainTo(topicMessageCountTracker);
        topicMessageCountTracker.getCounters().forEach((topic, count) -> this.messageCounters.get(WeightedMultiTopicsConsumerImpl.partitionTopic(topic)).addAndGet(-1 * count));
    }

    protected void addMessageCounterForTopic(String topic) {
        this.messageCounters.putIfAbsent(WeightedMultiTopicsConsumerImpl.partitionTopic(topic), new AtomicInteger());
    }

    protected Message<T> internalReceive() throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.take();
            this.decreaseIncomingMessageSize(message);
            Preconditions.checkState((boolean)(message instanceof TopicMessageImpl));
            this.unAckedMessageTracker.add(message.getMessageId());
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    protected Message<T> internalReceive(int timeout, TimeUnit unit) throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.poll(timeout, unit);
            if (message != null) {
                this.decreaseIncomingMessageSize(message);
                Preconditions.checkArgument((boolean)(message instanceof TopicMessageImpl));
                this.unAckedMessageTracker.add(message.getMessageId());
            }
            this.resumeReceivingFromPausedConsumersIfNeeded();
            return message;
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    protected Messages<T> internalBatchReceive() throws PulsarClientException {
        try {
            return this.internalBatchReceiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumBatchReceiveFailed();
                throw PulsarClientException.unwrap((Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Messages<T>> internalBatchReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture result = cancellationHandler.createFuture();
        try {
            this.lock.writeLock().lock();
            if (this.hasEnoughMessagesForBatchReceive()) {
                MessagesImpl messages = this.getNewMessagesImpl();
                Message msgPeeked = (Message)this.incomingMessages.peek();
                while (msgPeeked != null && messages.canAdd(msgPeeked)) {
                    Message msg = (Message)this.incomingMessages.poll();
                    if (msg != null) {
                        this.decreaseIncomingMessageSize(msg);
                        Message interceptMsg = this.beforeConsume(msg);
                        messages.add(interceptMsg);
                    }
                    msgPeeked = (Message)this.incomingMessages.peek();
                }
                result.complete(messages);
            } else {
                ConsumerBase.OpBatchReceive opBatchReceive = ConsumerBase.OpBatchReceive.of((CompletableFuture)result);
                this.pendingBatchReceives.add(opBatchReceive);
                cancellationHandler.setCancelAction(() -> this.pendingBatchReceives.remove(opBatchReceive));
            }
            this.resumeReceivingFromPausedConsumersIfNeeded();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture result = cancellationHandler.createFuture();
        Message message = (Message)this.incomingMessages.poll();
        if (message == null) {
            this.pendingReceives.add(result);
            cancellationHandler.setCancelAction(() -> this.pendingReceives.remove(result));
        } else {
            this.decreaseIncomingMessageSize(message);
            Preconditions.checkState((boolean)(message instanceof TopicMessageImpl));
            this.unAckedMessageTracker.add(message.getMessageId());
            this.resumeReceivingFromPausedConsumersIfNeeded();
            result.complete(message);
        }
        return result;
    }

    protected CompletableFuture<Void> doAcknowledge(MessageId messageId, CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txnImpl) {
        Preconditions.checkArgument((boolean)(messageId instanceof TopicMessageIdImpl));
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException("Consumer already closed"));
        }
        if (ackType == CommandAck.AckType.Cumulative) {
            Consumer individualConsumer = (Consumer)this.consumers.get(topicMessageId.getTopicPartitionName());
            if (individualConsumer != null) {
                MessageId innerId = topicMessageId.getInnerMessageId();
                return individualConsumer.acknowledgeCumulativeAsync(innerId);
            }
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotConnectedException());
        }
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        MessageId innerId = topicMessageId.getInnerMessageId();
        return consumer.doAcknowledgeWithTxn(innerId, ackType, properties, txnImpl).thenRun(() -> this.unAckedMessageTracker.remove((MessageId)topicMessageId));
    }

    protected CompletableFuture<Void> doAcknowledge(List<MessageId> messageIdList, CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txn) {
        ArrayList resultFutures = new ArrayList();
        if (ackType == CommandAck.AckType.Cumulative) {
            messageIdList.forEach(messageId -> resultFutures.add(this.doAcknowledge((MessageId)messageId, ackType, properties, txn)));
            return CompletableFuture.allOf(resultFutures.toArray(new CompletableFuture[0]));
        }
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException("Consumer already closed"));
        }
        HashMap<String, List> topicToMessageIdMap = new HashMap<String, List>();
        for (MessageId messageId2 : messageIdList) {
            if (!(messageId2 instanceof TopicMessageIdImpl)) {
                return FutureUtil.failedFuture((Throwable)new IllegalArgumentException("messageId is not instance of TopicMessageIdImpl"));
            }
            TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId2;
            topicToMessageIdMap.putIfAbsent(topicMessageId.getTopicPartitionName(), new ArrayList());
            ((List)topicToMessageIdMap.get(topicMessageId.getTopicPartitionName())).add(topicMessageId.getInnerMessageId());
        }
        topicToMessageIdMap.forEach((topicPartitionName, messageIds) -> {
            ConsumerImpl<T> consumer = this.consumers.get(topicPartitionName);
            resultFutures.add(consumer.doAcknowledgeWithTxn(messageIds, ackType, properties, txn).thenAccept(res -> messageIdList.forEach(arg_0 -> ((UnAckedMessageTracker)this.unAckedMessageTracker).remove(arg_0))));
        });
        return CompletableFuture.allOf(resultFutures.toArray(new CompletableFuture[0]));
    }

    protected CompletableFuture<Void> doReconsumeLater(Message<?> message, CommandAck.AckType ackType, Map<String, String> properties, long delayTime, TimeUnit unit) {
        MessageId messageId = message.getMessageId();
        Preconditions.checkArgument((boolean)(messageId instanceof TopicMessageIdImpl));
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        if (this.getState() != HandlerState.State.Ready) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException("Consumer already closed"));
        }
        if (ackType == CommandAck.AckType.Cumulative) {
            Consumer individualConsumer = (Consumer)this.consumers.get(topicMessageId.getTopicPartitionName());
            if (individualConsumer != null) {
                MessageId innerId = topicMessageId.getInnerMessageId();
                return individualConsumer.reconsumeLaterCumulativeAsync(message, delayTime, unit);
            }
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotConnectedException());
        }
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        MessageId innerId = topicMessageId.getInnerMessageId();
        return consumer.doReconsumeLater(message, ackType, properties, delayTime, unit).thenRun(() -> this.unAckedMessageTracker.remove((MessageId)topicMessageId));
    }

    public void negativeAcknowledge(MessageId messageId) {
        Preconditions.checkArgument((boolean)(messageId instanceof TopicMessageIdImpl));
        TopicMessageIdImpl topicMessageId = (TopicMessageIdImpl)messageId;
        ConsumerImpl<T> consumer = this.consumers.get(topicMessageId.getTopicPartitionName());
        consumer.negativeAcknowledge(topicMessageId.getInnerMessageId());
    }

    public CompletableFuture<Void> unsubscribeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        this.setState(HandlerState.State.Closing);
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(c -> c.unsubscribeAsync()).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenCompose(r -> {
            this.setState(HandlerState.State.Closed);
            this.cleanupMultiConsumer();
            log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName});
            return this.failPendingReceive();
        })).whenComplete((r, ex) -> {
            if (ex == null) {
                unsubscribeFuture.complete(null);
            } else {
                this.setState(HandlerState.State.Failed);
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{this.topic, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.unAckedMessageTracker.close();
            return CompletableFuture.completedFuture(null);
        }
        this.setState(HandlerState.State.Closing);
        if (this.partitionsAutoUpdateTimeout != null) {
            this.partitionsAutoUpdateTimeout.cancel();
            this.partitionsAutoUpdateTimeout = null;
        }
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        List futureList = this.consumers.values().stream().map(c -> c.closeAsync()).collect(Collectors.toList());
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenCompose(r -> {
            this.setState(HandlerState.State.Closed);
            this.cleanupMultiConsumer();
            log.info("[{}] [{}] Closed Topics Consumer", (Object)this.topic, (Object)this.subscription);
            return this.failPendingReceive();
        })).whenComplete((r, ex) -> {
            if (ex == null) {
                closeFuture.complete(null);
            } else {
                this.setState(HandlerState.State.Failed);
                closeFuture.completeExceptionally((Throwable)ex);
                log.error("[{}] [{}] Could not close Topics Consumer", new Object[]{this.topic, this.subscription, ex.getCause()});
            }
        });
        return closeFuture;
    }

    private void cleanupMultiConsumer() {
        this.unAckedMessageTracker.close();
        this.client.cleanupConsumer((ConsumerBase)this);
    }

    public boolean isConnected() {
        return this.consumers.values().stream().allMatch(consumer -> consumer.isConnected());
    }

    String getHandlerName() {
        return this.subscription;
    }

    private ConsumerConfigurationData<T> getInternalConsumerConfig() {
        ConsumerConfigurationData internalConsumerConfig = this.conf.clone();
        internalConsumerConfig.setSubscriptionName(this.subscription);
        internalConsumerConfig.setConsumerName(this.consumerName);
        internalConsumerConfig.setMessageListener(null);
        return internalConsumerConfig;
    }

    public void redeliverUnacknowledgedMessages() {
        this.lock.writeLock().lock();
        try {
            this.consumers.values().stream().forEach(consumer -> {
                consumer.redeliverUnacknowledgedMessages();
                consumer.unAckedChunkedMessageIdSequenceMap.clear();
            });
            this.resetIncomingMessageSize();
            this.unAckedMessageTracker.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    public void redeliverUnacknowledgedMessages(Set<MessageId> messageIds) {
        if (messageIds.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((boolean)(messageIds.stream().findFirst().get() instanceof TopicMessageIdImpl));
        if (this.conf.getSubscriptionType() != SubscriptionType.Shared) {
            this.redeliverUnacknowledgedMessages();
            return;
        }
        this.removeExpiredMessagesFromQueue(messageIds);
        messageIds.stream().map(messageId -> (TopicMessageIdImpl)messageId).collect(Collectors.groupingBy(TopicMessageIdImpl::getTopicPartitionName, Collectors.toSet())).forEach((topicName, messageIds1) -> this.consumers.get(topicName).redeliverUnacknowledgedMessages(messageIds1.stream().map(mid -> mid.getInnerMessageId()).collect(Collectors.toSet())));
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    protected void completeOpBatchReceive(ConsumerBase.OpBatchReceive<T> op) {
        this.notifyPendingBatchReceivedCallBack(op);
        this.resumeReceivingFromPausedConsumersIfNeeded();
    }

    public void seek(MessageId messageId) throws PulsarClientException {
        try {
            this.seekAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(long timestamp) throws PulsarClientException {
        try {
            this.seekAsync(timestamp).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(Function<String, Object> function) throws PulsarClientException {
        try {
            this.seekAsync(function).get();
        }
        catch (Exception var3) {
            throw PulsarClientException.unwrap((Throwable)var3);
        }
    }

    public CompletableFuture<Void> seekAsync(Function<String, Object> function) {
        ArrayList futures = new ArrayList(this.consumers.size());
        this.consumers.values().forEach(consumer -> futures.add(consumer.seekAsync(function)));
        this.unAckedMessageTracker.clear();
        this.resetIncomingMessageSize();
        return FutureUtil.waitForAll(futures);
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        CompletableFuture<Void> seekFuture = new CompletableFuture<Void>();
        MessageIdImpl targetMessageId = MessageIdImpl.convertToMessageIdImpl((MessageId)messageId);
        if (targetMessageId == null || WeightedMultiTopicsConsumerImpl.isIllegalMultiTopicsMessageId(messageId)) {
            seekFuture.completeExceptionally((Throwable)new PulsarClientException("Illegal messageId, messageId can only be earliest/latest"));
            return seekFuture;
        }
        ArrayList futures = new ArrayList(this.consumers.size());
        this.consumers.values().forEach(consumerImpl -> futures.add(consumerImpl.seekAsync((MessageId)targetMessageId)));
        this.unAckedMessageTracker.clear();
        this.resetIncomingMessageSize();
        FutureUtil.waitForAll(futures).whenComplete((result, exception) -> {
            if (exception != null) {
                seekFuture.completeExceptionally((Throwable)exception);
            } else {
                seekFuture.complete((Void)result);
            }
        });
        return seekFuture;
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        ArrayList futures = new ArrayList(this.consumers.size());
        this.consumers.values().forEach(consumer -> futures.add(consumer.seekAsync(timestamp)));
        return FutureUtil.waitForAll(futures);
    }

    public int getAvailablePermits() {
        return this.consumers.values().stream().mapToInt(ConsumerImpl::getAvailablePermits).sum();
    }

    public boolean hasReachedEndOfTopic() {
        return this.consumers.values().stream().allMatch(Consumer::hasReachedEndOfTopic);
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        try {
            return this.hasMessageAvailableAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        ArrayList<CompletionStage> futureList = new ArrayList<CompletionStage>();
        AtomicBoolean hasMessageAvailable = new AtomicBoolean(false);
        for (ConsumerImpl<T> consumer : this.consumers.values()) {
            futureList.add(consumer.hasMessageAvailableAsync().thenAccept(isAvailable -> {
                if (isAvailable.booleanValue()) {
                    hasMessageAvailable.compareAndSet(false, true);
                }
            }));
        }
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        FutureUtil.waitForAll(futureList).whenComplete((result, exception) -> {
            if (exception != null) {
                completableFuture.completeExceptionally((Throwable)exception);
            } else {
                completableFuture.complete(hasMessageAvailable.get());
            }
        });
        return completableFuture;
    }

    public int numMessagesInQueue() {
        return this.incomingMessages.size() + this.consumers.values().stream().mapToInt(ConsumerImpl::numMessagesInQueue).sum();
    }

    public synchronized ConsumerStats getStats() {
        if (this.stats == null) {
            return null;
        }
        this.stats.reset();
        this.consumers.values().stream().forEach(consumer -> this.stats.updateCumulativeStats((ConsumerStats)consumer.getStats()));
        return this.stats;
    }

    public UnAckedMessageTracker getUnAckedMessageTracker() {
        return this.unAckedMessageTracker;
    }

    private void removeExpiredMessagesFromQueue(Set<MessageId> messageIds) {
        Message peek = (Message)this.incomingMessages.peek();
        if (peek != null) {
            if (!messageIds.contains(peek.getMessageId())) {
                return;
            }
            Message message = (Message)this.incomingMessages.poll();
            Preconditions.checkState((boolean)(message instanceof TopicMessageImpl));
            while (message != null) {
                this.decreaseIncomingMessageSize(message);
                MessageId messageId = message.getMessageId();
                if (!messageIds.contains(messageId)) {
                    messageIds.add(messageId);
                    break;
                }
                message = (Message)this.incomingMessages.poll();
            }
        }
    }

    private TopicName getTopicName(String topic) {
        try {
            return TopicName.get((String)topic);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private String getFullTopicName(String topic) {
        TopicName topicName = this.getTopicName(topic);
        return topicName != null ? topicName.toString() : null;
    }

    private void removeTopic(String topic) {
        String fullTopicName = this.getFullTopicName(topic);
        if (fullTopicName != null) {
            this.partitionedTopics.remove(topic);
        }
    }

    public CompletableFuture<Void> subscribeAsync(String topicName, boolean createTopicIfDoesNotExist) {
        TopicName topicNameInstance = this.getTopicName(topicName);
        if (topicNameInstance == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        String fullTopicName = topicNameInstance.toString();
        if (this.consumers.containsKey(fullTopicName) || this.partitionedTopics.containsKey(topicNameInstance.getPartitionedTopicName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Already subscribed to " + topicName));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        ((CompletableFuture)this.client.getPartitionedTopicMetadata(topicName).thenAccept(metadata -> this.subscribeTopicPartitions(subscribeResult, fullTopicName, metadata.partitions, createTopicIfDoesNotExist))).exceptionally(ex1 -> {
            log.warn("[{}] Failed to get partitioned topic metadata: {}", (Object)fullTopicName, (Object)ex1.getMessage());
            subscribeResult.completeExceptionally((Throwable)ex1);
            return null;
        });
        return subscribeResult;
    }

    @VisibleForTesting
    CompletableFuture<Void> subscribeAsync(String topicName, int numberPartitions) {
        TopicName topicNameInstance = this.getTopicName(topicName);
        if (topicNameInstance == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topic name not valid"));
        }
        String fullTopicName = topicNameInstance.toString();
        if (this.consumers.containsKey(fullTopicName) || this.partitionedTopics.containsKey(topicNameInstance.getPartitionedTopicName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Already subscribed to " + topicName));
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> subscribeResult = new CompletableFuture<Void>();
        this.subscribeTopicPartitions(subscribeResult, fullTopicName, numberPartitions, true);
        return subscribeResult;
    }

    private void subscribeTopicPartitions(CompletableFuture<Void> subscribeResult, String topicName, int numPartitions, boolean createIfDoesNotExist) {
        this.client.preProcessSchemaBeforeSubscribe(this.client, this.schema, topicName).whenComplete((schema, cause) -> {
            if (null == cause) {
                this.doSubscribeTopicPartitions((Schema<T>)schema, subscribeResult, topicName, numPartitions, createIfDoesNotExist);
            } else {
                subscribeResult.completeExceptionally((Throwable)cause);
            }
        });
    }

    private void doSubscribeTopicPartitions(Schema<T> schema, CompletableFuture<Void> subscribeResult, String topicName, int numPartitions, boolean createIfDoesNotExist) {
        List futureList;
        if (log.isDebugEnabled()) {
            log.debug("Subscribe to topic {} metadata.partitions: {}", (Object)topicName, (Object)numPartitions);
        }
        if (numPartitions != 0) {
            boolean isTopicBeingSubscribedForInOtherThread;
            boolean bl = isTopicBeingSubscribedForInOtherThread = this.partitionedTopics.putIfAbsent(topicName, numPartitions) != null;
            if (isTopicBeingSubscribedForInOtherThread) {
                String errorMessage = String.format("[%s] Failed to subscribe for topic [%s] in topics consumer. Topic is already being subscribed for in other thread.", this.topic, topicName);
                log.warn(errorMessage);
                subscribeResult.completeExceptionally((Throwable)new PulsarClientException(errorMessage));
                return;
            }
            this.allTopicPartitionsNumber.addAndGet(numPartitions);
            ConsumerConfigurationData<T> configurationData = this.getInternalConsumerConfig();
            try {
                int receiverQueueSize = this.getReceiverQueueSize(topicName);
                configurationData.setReceiverQueueSize(receiverQueueSize);
            }
            catch (Exception ex2) {
                subscribeResult.completeExceptionally((Throwable)new PulsarClientException((Throwable)ex2));
                return;
            }
            futureList = IntStream.range(0, numPartitions).mapToObj(partitionIndex -> {
                String partitionName = TopicName.get((String)topicName).getPartition(partitionIndex).toString();
                CompletableFuture subFuture = new CompletableFuture();
                ConsumerImpl newConsumer = ConsumerImpl.newConsumerImpl((PulsarClientImpl)this.client, (String)partitionName, (ConsumerConfigurationData)configurationData, (ExecutorProvider)this.client.externalExecutorProvider(), (int)partitionIndex, (boolean)true, subFuture, (MessageId)this.startMessageId, (Schema)schema, (ConsumerInterceptors)this.interceptors, (boolean)createIfDoesNotExist, (long)this.startMessageRollbackDurationInSec);
                this.addMessageCounterForTopic(newConsumer.getTopic());
                this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
                return subFuture;
            }).collect(Collectors.toList());
        } else {
            this.allTopicPartitionsNumber.incrementAndGet();
            CompletableFuture subFuture = new CompletableFuture();
            ConsumerConfigurationData configurationData = this.internalConfig.clone();
            try {
                int receiverQueueSize = this.getReceiverQueueSize(topicName);
                configurationData.setReceiverQueueSize(receiverQueueSize);
            }
            catch (Exception ex3) {
                subscribeResult.completeExceptionally((Throwable)new PulsarClientException((Throwable)ex3));
                return;
            }
            this.consumers.compute(topicName, (key, existingValue) -> {
                if (existingValue != null) {
                    String errorMessage = String.format("[%s] Failed to subscribe for topic [%s] in topics consumer. Topic is already being subscribed for in other thread.", this.topic, topicName);
                    log.warn(errorMessage);
                    subscribeResult.completeExceptionally((Throwable)new PulsarClientException(errorMessage));
                    return existingValue;
                }
                ConsumerImpl newConsumer = ConsumerImpl.newConsumerImpl((PulsarClientImpl)this.client, (String)topicName, (ConsumerConfigurationData)configurationData, (ExecutorProvider)this.client.externalExecutorProvider(), (int)-1, (boolean)true, (CompletableFuture)subFuture, null, (Schema)schema, (ConsumerInterceptors)this.interceptors, (boolean)createIfDoesNotExist);
                this.addMessageCounterForTopic(newConsumer.getTopic());
                Object object = this.pauseMutex;
                synchronized (object) {
                    if (this.paused) {
                        newConsumer.pause();
                    }
                }
                return newConsumer;
            });
            futureList = Collections.singletonList(subFuture);
        }
        ((CompletableFuture)FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> {
            if (this.allTopicPartitionsNumber.get() > this.maxReceiverQueueSize) {
                this.setMaxReceiverQueueSize(this.allTopicPartitionsNumber.get());
            }
            this.startReceivingMessages(this.consumers.values().stream().filter(consumer1 -> {
                String consumerTopicName = consumer1.getTopic();
                return TopicName.get((String)consumerTopicName).getPartitionedTopicName().equals(TopicName.get((String)topicName).getPartitionedTopicName());
            }).collect(Collectors.toList()));
            subscribeResult.complete(null);
            log.info("[{}] [{}] Success subscribe new topic {} in topics consumer, partitions: {}, allTopicPartitionsNumber: {}", new Object[]{this.topic, this.subscription, topicName, numPartitions, this.allTopicPartitionsNumber.get()});
        })).exceptionally(ex -> {
            this.handleSubscribeOneTopicError(topicName, (Throwable)ex, subscribeResult);
            return null;
        });
    }

    private int getReceiverQueueSize(String topicName) {
        int receiverQueueSize = this.throttleReceiverQueue ? this.topicThresholdDistribution.getValue(topicName) : this.topicThresholdDistribution.getMaxValue();
        return receiverQueueSize;
    }

    private void handleSubscribeOneTopicError(String topicName, Throwable error, CompletableFuture<Void> subscribeFuture) {
        log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer {}", new Object[]{this.topic, topicName, error.getMessage()});
        this.client.externalExecutorProvider().getExecutor().submit(() -> {
            AtomicInteger toCloseNum = new AtomicInteger(0);
            this.consumers.values().stream().filter(consumer1 -> {
                String consumerTopicName = consumer1.getTopic();
                if (TopicName.get((String)consumerTopicName).getPartitionedTopicName().equals(TopicName.get((String)topicName).getPartitionedTopicName())) {
                    toCloseNum.incrementAndGet();
                    return true;
                }
                return false;
            }).collect(Collectors.toList()).forEach(consumer2 -> consumer2.closeAsync().whenComplete((r, ex) -> {
                consumer2.subscribeFuture().completeExceptionally(error);
                this.allTopicPartitionsNumber.decrementAndGet();
                this.consumers.remove(consumer2.getTopic());
                if (toCloseNum.decrementAndGet() == 0) {
                    log.warn("[{}] Failed to subscribe for topic [{}] in topics consumer, subscribe error: {}", new Object[]{this.topic, topicName, error.getMessage()});
                    this.removeTopic(topicName);
                    subscribeFuture.completeExceptionally(error);
                }
            }));
        });
    }

    public CompletableFuture<Void> unsubscribeAsync(String topicName) {
        Preconditions.checkArgument((boolean)TopicName.isValid((String)topicName), (Object)("Invalid topic name:" + topicName));
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        if (this.partitionsAutoUpdateTimeout != null) {
            this.partitionsAutoUpdateTimeout.cancel();
            this.partitionsAutoUpdateTimeout = null;
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        String topicPartName = TopicName.get((String)topicName).getPartitionedTopicName();
        List consumersToUnsub = this.consumers.values().stream().filter(consumer -> {
            String consumerTopicName = consumer.getTopic();
            return TopicName.get((String)consumerTopicName).getPartitionedTopicName().equals(topicPartName);
        }).collect(Collectors.toList());
        List futureList = consumersToUnsub.stream().map(ConsumerImpl::unsubscribeAsync).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                consumersToUnsub.forEach(consumer1 -> {
                    this.consumers.remove(consumer1.getTopic());
                    this.pausedConsumers.remove(consumer1);
                    this.allTopicPartitionsNumber.decrementAndGet();
                });
                this.removeTopic(topicName);
                ((UnAckedTopicMessageTracker)this.unAckedMessageTracker).removeTopicMessages(topicName);
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Unsubscribed Topics Consumer, allTopicPartitionsNumber: {}", new Object[]{topicName, this.subscription, this.consumerName, this.allTopicPartitionsNumber});
            } else {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                this.setState(HandlerState.State.Failed);
                log.error("[{}] [{}] [{}] Could not unsubscribe Topics Consumer", new Object[]{topicName, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public CompletableFuture<Void> removeConsumerAsync(String topicName) {
        Preconditions.checkArgument((boolean)TopicName.isValid((String)topicName), (Object)("Invalid topic name:" + topicName));
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Topics Consumer was already closed"));
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        String topicPartName = TopicName.get((String)topicName).getPartitionedTopicName();
        List consumersToClose = this.consumers.values().stream().filter(consumer -> {
            String consumerTopicName = consumer.getTopic();
            return TopicName.get((String)consumerTopicName).getPartitionedTopicName().equals(topicPartName);
        }).collect(Collectors.toList());
        List futureList = consumersToClose.stream().map(ConsumerImpl::closeAsync).collect(Collectors.toList());
        FutureUtil.waitForAll(futureList).whenComplete((r, ex) -> {
            if (ex == null) {
                consumersToClose.forEach(consumer1 -> {
                    this.consumers.remove(consumer1.getTopic());
                    this.pausedConsumers.remove(consumer1);
                    this.allTopicPartitionsNumber.decrementAndGet();
                });
                this.removeTopic(topicName);
                ((UnAckedTopicMessageTracker)this.unAckedMessageTracker).removeTopicMessages(topicName);
                unsubscribeFuture.complete(null);
                log.info("[{}] [{}] [{}] Removed Topics Consumer, allTopicPartitionsNumber: {}", new Object[]{topicName, this.subscription, this.consumerName, this.allTopicPartitionsNumber});
            } else {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                this.setState(HandlerState.State.Failed);
                log.error("[{}] [{}] [{}] Could not remove Topics Consumer", new Object[]{topicName, this.subscription, this.consumerName, ex.getCause()});
            }
        });
        return unsubscribeFuture;
    }

    public List<String> getPartitionedTopics() {
        return this.partitionedTopics.keySet().stream().collect(Collectors.toList());
    }

    public List<String> getPartitions() {
        return this.consumers.keySet().stream().collect(Collectors.toList());
    }

    public List<ConsumerImpl<T>> getConsumers() {
        return this.consumers.values().stream().collect(Collectors.toList());
    }

    int getPartitionsOfTheTopicMap() {
        return this.partitionedTopics.values().stream().mapToInt(Integer::intValue).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.pauseMutex;
        synchronized (object) {
            this.paused = true;
            this.consumers.forEach((name, consumer) -> consumer.pause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.pauseMutex;
        synchronized (object) {
            this.paused = false;
            this.consumers.forEach((name, consumer) -> consumer.resume());
        }
    }

    public long getLastDisconnectedTimestamp() {
        long lastDisconnectedTimestamp = 0L;
        Optional<ConsumerImpl> c = this.consumers.values().stream().max(Comparator.comparingLong(ConsumerImpl::getLastDisconnectedTimestamp));
        if (c.isPresent()) {
            lastDisconnectedTimestamp = c.get().getLastDisconnectedTimestamp();
        }
        return lastDisconnectedTimestamp;
    }

    private CompletableFuture<Void> subscribeIncreasedTopicPartitions(String topicName) {
        int oldPartitionNumber = this.partitionedTopics.get(topicName);
        return this.client.getPartitionsForTopic(topicName).thenCompose(list -> {
            int currentPartitionNumber = Long.valueOf(list.stream().filter(t -> TopicName.get((String)t).isPartitioned()).count()).intValue();
            if (log.isDebugEnabled()) {
                log.debug("[{}] partitions number. old: {}, new: {}", new Object[]{topicName, oldPartitionNumber, currentPartitionNumber});
            }
            if (oldPartitionNumber == currentPartitionNumber) {
                return CompletableFuture.completedFuture(null);
            }
            if (currentPartitionNumber == 0) {
                this.partitionedTopics.put(topicName, 0);
                this.allTopicPartitionsNumber.addAndGet(-oldPartitionNumber);
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                for (Map.Entry<String, ConsumerImpl<T>> e : this.consumers.entrySet()) {
                    String partitionedTopicName = TopicName.get((String)e.getKey()).getPartitionedTopicName();
                    if (!partitionedTopicName.equals(topicName)) continue;
                    futures.add(e.getValue().closeAsync());
                    this.consumers.remove(e.getKey());
                }
                return FutureUtil.waitForAll(futures);
            }
            if (oldPartitionNumber < currentPartitionNumber) {
                this.allTopicPartitionsNumber.addAndGet(currentPartitionNumber - oldPartitionNumber);
                this.partitionedTopics.put(topicName, currentPartitionNumber);
                List newPartitions = list.subList(oldPartitionNumber, currentPartitionNumber);
                List futureList = newPartitions.stream().map(partitionName -> {
                    int partitionIndex = TopicName.getPartitionIndex((String)partitionName);
                    CompletableFuture subFuture = new CompletableFuture();
                    ConsumerConfigurationData<T> configurationData = this.getInternalConsumerConfig();
                    int receiverQueueSize = this.getReceiverQueueSize(topicName);
                    configurationData.setReceiverQueueSize(receiverQueueSize);
                    ConsumerImpl newConsumer = ConsumerImpl.newConsumerImpl((PulsarClientImpl)this.client, (String)partitionName, configurationData, (ExecutorProvider)this.client.externalExecutorProvider(), (int)partitionIndex, (boolean)true, subFuture, null, (Schema)this.schema, (ConsumerInterceptors)this.interceptors, (boolean)true);
                    Object object = this.pauseMutex;
                    synchronized (object) {
                        if (this.paused) {
                            newConsumer.pause();
                        }
                        this.addMessageCounterForTopic(newConsumer.getTopic());
                        this.consumers.putIfAbsent(newConsumer.getTopic(), newConsumer);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] create consumer {} for partitionName: {}", new Object[]{topicName, newConsumer.getTopic(), partitionName});
                    }
                    return subFuture;
                }).collect(Collectors.toList());
                return FutureUtil.waitForAll(futureList).thenAccept(finalFuture -> {
                    List<ConsumerImpl<T>> newConsumerList = newPartitions.stream().map(partitionTopic -> this.consumers.get(partitionTopic)).collect(Collectors.toList());
                    this.startReceivingMessages(newConsumerList);
                });
            }
            log.error("[{}] not support shrink topic partitions. old: {}, new: {}", new Object[]{topicName, oldPartitionNumber, currentPartitionNumber});
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotSupportedException("not support shrink topic partitions"));
        });
    }

    @VisibleForTesting
    public Timeout getPartitionsAutoUpdateTimeout() {
        return this.partitionsAutoUpdateTimeout;
    }

    public CompletableFuture<MessageId> getLastMessageIdAsync() {
        CompletableFuture<MessageId> returnFuture = new CompletableFuture<MessageId>();
        Map<String, CompletableFuture> messageIdFutures = this.consumers.entrySet().stream().map(entry -> Pair.of(entry.getKey(), (Object)((ConsumerImpl)entry.getValue()).getLastMessageIdAsync())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        CompletableFuture.allOf((CompletableFuture[])messageIdFutures.entrySet().stream().map(Map.Entry::getValue).toArray(CompletableFuture[]::new)).whenComplete((ignore, ex) -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            messageIdFutures.forEach((key, future) -> {
                MessageId messageId;
                try {
                    messageId = (MessageId)future.get();
                }
                catch (Exception e) {
                    log.warn("[{}] Exception when topic {} getLastMessageId.", key, (Object)e);
                    messageId = MessageId.earliest;
                }
                builder.put(key, (Object)messageId);
            });
            returnFuture.complete((MessageId)new MultiMessageIdImpl((Map)builder.build()));
        });
        return returnFuture;
    }

    public void tryAcknowledgeMessage(Message<T> msg) {
        if (msg != null) {
            this.acknowledgeCumulativeAsync(msg);
        }
    }

    private class TopicsPartitionChangedListener
    implements PartitionsChangedListener {
        private TopicsPartitionChangedListener() {
        }

        public CompletableFuture<Void> onTopicsExtended(Collection<String> topicsExtended) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            if (topicsExtended.isEmpty()) {
                future.complete(null);
                return future;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}]  run onTopicsExtended: {}, size: {}", new Object[]{WeightedMultiTopicsConsumerImpl.this.topic, topicsExtended, topicsExtended.size()});
            }
            ArrayList futureList = Lists.newArrayListWithExpectedSize((int)topicsExtended.size());
            topicsExtended.forEach(topic -> futureList.add(WeightedMultiTopicsConsumerImpl.this.subscribeIncreasedTopicPartitions(topic)));
            ((CompletableFuture)FutureUtil.waitForAll((List)futureList).thenAccept(finalFuture -> future.complete(null))).exceptionally(ex -> {
                log.warn("[{}] Failed to subscribe increased topics partitions: {}", (Object)WeightedMultiTopicsConsumerImpl.this.topic, (Object)ex.getMessage());
                future.completeExceptionally((Throwable)ex);
                return null;
            });
            return future;
        }
    }
}

