/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerBuilderImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.WeightedMultiTopicsConsumerImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.weight.WeightedConsumerConfiguration;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class WeightedConsumerBuilder<T>
extends ConsumerBuilderImpl<T> {
    private WeightedConsumerConfiguration weightConf;
    private Integer retryTopicWeight;

    public WeightedConsumerBuilder(PulsarClient client, Schema<T> schema) {
        this((PulsarClientImpl)client, new ConsumerConfigurationData(), schema);
    }

    WeightedConsumerBuilder(PulsarClientImpl client, ConsumerConfigurationData<T> conf, Schema<T> schema) {
        super(client, conf, schema);
        this.weightConf = WeightedConsumerConfiguration.loadFromConf(conf);
    }

    public WeightedConsumerConfiguration getWeightConf() {
        return this.weightConf;
    }

    public WeightedConsumerBuilder<T> loadConf(Map<String, Object> config) {
        super.loadConf(config);
        this.weightConf = WeightedConsumerConfiguration.loadFromConf(this.getConf());
        return this;
    }

    public WeightedConsumerBuilder<T> clone() {
        return new WeightedConsumerBuilder<T>(this.getClient(), this.getConf().clone(), this.getSchema());
    }

    public WeightedConsumerBuilder<T> distributionStrategy(WeightedConsumerConfiguration.DistributionStrategy distributionStrategy) {
        this.weightConf.setDistributionStrategy(distributionStrategy);
        return this;
    }

    public WeightedConsumerBuilder<T> minBound(int minBound) {
        this.weightConf.setMinBound(minBound);
        return this;
    }

    public WeightedConsumerBuilder<T> maxBound(int maxBound) {
        this.weightConf.setMaxBound(maxBound);
        return this;
    }

    public WeightedConsumerBuilder<T> retryTopicWeight(Integer weight) {
        if (weight != null) {
            Preconditions.checkArgument((weight >= 1 && weight <= this.weightConf.getMaxWeightAllowed() ? 1 : 0) != 0, (String)"non-null weights should be in the range [1,maxWeightAllowed(%s)]", (int)this.weightConf.getMaxWeightAllowed());
        }
        this.retryTopicWeight = weight;
        return this;
    }

    public WeightedConsumerBuilder<T> throttleReceiveQueue(boolean shouldThrotle) {
        this.weightConf.setThrottleReceiveQueue(shouldThrotle);
        return this;
    }

    public WeightedConsumerBuilder<T> queueResumeThreshold(int resumeThreshold) {
        this.weightConf.setQueueResumeThreshold(resumeThreshold);
        return this;
    }

    public WeightedConsumerBuilder<T> maxWeightAllowed(int maxWeightAllowed) {
        this.weightConf.setMaxWeightAllowed(maxWeightAllowed);
        return this;
    }

    public WeightedConsumerBuilder<T> topic(String topic, Integer weight) {
        this.weightConf.addTopic(topic, weight);
        return this;
    }

    public WeightedConsumerBuilder<T> topics(Map<String, Integer> topicWeights) {
        Preconditions.checkArgument((topicWeights != null && topicWeights.size() > 0 ? 1 : 0) != 0, (Object)"non-empty topic-weight map required");
        for (Map.Entry<String, Integer> entry : topicWeights.entrySet()) {
            this.topic(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private String getSubscriptionName(ConsumerConfigurationData conf) {
        String subscriptionName = conf.getSubscriptionName();
        subscriptionName.replace("/", "__");
        return subscriptionName;
    }

    public CompletableFuture<Consumer<T>> subscribeAsync() {
        this.weightConf.populateBuilder(this);
        ConsumerConfigurationData conf = this.getConf();
        PulsarClientImpl client = this.getClient();
        Schema schema = this.getSchema();
        List interceptorList = this.getInterceptorList();
        if (conf.getTopicNames().isEmpty() && conf.getTopicsPattern() == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Topic name must be set on the consumer builder"));
        }
        if (StringUtils.isBlank((CharSequence)conf.getSubscriptionName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Subscription name must be set on the consumer builder"));
        }
        if (conf.getKeySharedPolicy() != null && conf.getSubscriptionType() != SubscriptionType.Key_Shared) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("KeySharedPolicy must set with KeyShared subscription"));
        }
        if (conf.isRetryEnable() && conf.getTopicNames().size() > 0) {
            TopicName topicFirst = TopicName.get((String)((String)conf.getTopicNames().iterator().next()));
            String subscriptionName = this.getSubscriptionName(conf);
            String retryLetterTopic = topicFirst.getNamespace() + "/" + subscriptionName + "-RETRY";
            String deadLetterTopic = topicFirst.getNamespace() + "/" + subscriptionName + "-DLQ";
            if (conf.getDeadLetterPolicy() == null) {
                conf.setDeadLetterPolicy(DeadLetterPolicy.builder().maxRedeliverCount(16).retryLetterTopic(retryLetterTopic).deadLetterTopic(deadLetterTopic).build());
            } else {
                if (StringUtils.isBlank((CharSequence)conf.getDeadLetterPolicy().getRetryLetterTopic())) {
                    conf.getDeadLetterPolicy().setRetryLetterTopic(retryLetterTopic);
                }
                if (StringUtils.isBlank((CharSequence)conf.getDeadLetterPolicy().getDeadLetterTopic())) {
                    conf.getDeadLetterPolicy().setDeadLetterTopic(deadLetterTopic);
                }
            }
            WeightedConsumerConfiguration.populateTopicInBuilder(this, conf.getDeadLetterPolicy().getRetryLetterTopic(), this.retryTopicWeight);
        }
        return interceptorList == null || interceptorList.size() == 0 ? WeightedMultiTopicsConsumerImpl.subscribeAsync((PulsarClient)client, conf, this.weightConf, schema, null) : WeightedMultiTopicsConsumerImpl.subscribeAsync((PulsarClient)client, conf, this.weightConf, schema, new ConsumerInterceptors(interceptorList));
    }
}

