/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.generator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.poseidon.helper.CallableNameHelper;
import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import com.flipkart.poseidon.serviceclients.AbstractServiceClient;
import com.flipkart.poseidon.serviceclients.FutureTaskResultToDomainObjectPromiseWrapper;
import com.flipkart.poseidon.serviceclients.ServiceExecutePropertiesBuilder;
import com.flipkart.poseidon.serviceclients.idl.pojo.EndPoint;
import com.flipkart.poseidon.serviceclients.idl.pojo.Parameter;
import com.flipkart.poseidon.serviceclients.idl.pojo.ServiceIDL;
import com.google.common.base.Joiner;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import flipkart.lego.api.entities.ServiceClient;
import java.beans.Introspector;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;

public class ServiceGenerator {
    private static final ServiceGenerator SERVICE_GENERATOR = new ServiceGenerator();
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("\\{parameters\\.(.*?)\\}");
    private static final String REQUEST_OBJECT_VAR_NAME = "requestObject";
    private static final String REQUEST_OBJECT_LOOP_VAR_NAME = "requestObject1";
    private static final String META_INFO_PARAMETER_NAME = "_metaInfo";
    private static final String META_INFO_COMMAND_NAME_VAR_NAME = "_metaInfoCommandName";

    private ServiceGenerator() {
    }

    public static ServiceGenerator getInstance() {
        return SERVICE_GENERATOR;
    }

    private String getInterfaceName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getName() + "Client";
    }

    private String getFullInterfaceName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getPackageName() + "." + this.getInterfaceName(serviceIdl);
    }

    private String getImplName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getName() + "ClientImpl";
    }

    private String getFullImplName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getPackageName() + "." + this.getImplName(serviceIdl);
    }

    private JType getJType(JCodeModel jCodeModel, String name) {
        if (name == null || name.length() == 0) {
            name = "void";
        }
        try {
            return jCodeModel.parseType(name);
        }
        catch (ClassNotFoundException e) {
            return jCodeModel.directClass(name);
        }
    }

    private Map<String, String> getAllHeaders(ServiceIDL serviceIdl, EndPoint endPoint) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (serviceIdl.getService().getHeaders() != null) {
            headersMap.putAll(serviceIdl.getService().getHeaders());
        }
        if (endPoint.getHeaders() != null) {
            headersMap.putAll(endPoint.getHeaders());
        }
        return headersMap;
    }

    private void generateMethodParam(ServiceIDL serviceIdl, JCodeModel jCodeModel, JMethod method, JDocComment methodComment, String paramName) {
        Parameter parameter = serviceIdl.getParameters().get(paramName);
        JType jType = this.getJType(jCodeModel, parameter.getType());
        if (!parameter.getOptional().booleanValue()) {
            method.param((JType)jType.boxify(), paramName).annotate(NotNull.class);
        } else {
            method.param((JType)jType.boxify(), paramName);
        }
        JCommentPart paramComment = methodComment.addParam(paramName);
        if (parameter.getDescription() != null) {
            for (String description : parameter.getDescription()) {
                paramComment.append((Object)description);
            }
        }
    }

    public void generateMetaInfo(ServiceIDL serviceIdl) throws Exception {
        for (Map.Entry<String, EndPoint> entry : serviceIdl.getEndPoints().entrySet()) {
            if (!entry.getValue().isIncludeMetaInfo()) continue;
            this.addMetaInfoAsParameter(serviceIdl);
            break;
        }
    }

    private void addMetaInfoAsParameter(ServiceIDL serviceIDL) throws Exception {
        for (String parameterName : serviceIDL.getParameters().keySet()) {
            if (!META_INFO_PARAMETER_NAME.equals(parameterName)) continue;
            throw new Exception("_metaInfo as parameter name is restricted for internal usage of poseidon.");
        }
        Parameter metaInfoParameter = new Parameter();
        metaInfoParameter.setType("java.util.Map<String,Object>");
        metaInfoParameter.setDescription(new String[]{"Map which has all meta info for a method overrides"});
        serviceIDL.getParameters().put(META_INFO_PARAMETER_NAME, metaInfoParameter);
    }

    private void addClassComments(ServiceIDL serviceIdl, JDefinedClass jDefinedClass) {
        JDocComment docComment = jDefinedClass.javadoc();
        docComment.addAll(Arrays.asList(serviceIdl.getService().getDescription()));
    }

    private void addAnnotations(JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        JAnnotationUse annotationUse = jDefinedClass.annotate(jCodeModel.ref("javax.annotation.Generated"));
        annotationUse.param("value", this.getClass().getName());
        annotationUse.param("date", new Date().toString());
        annotationUse.param("comments", "EDIT THIS IF YOU ARE ****");
    }

    private void addNameAnnotations(JDefinedClass jDefinedClass, String name) {
        JAnnotationUse nameAnnotation = jDefinedClass.annotate(Name.class);
        nameAnnotation.param("value", name);
    }

    private void addDescriptionAnnotations(JDefinedClass jDefinedClass, String shortDescription, String verboseDescription) {
        JAnnotationUse descriptionAnnotation = jDefinedClass.annotate(Description.class);
        descriptionAnnotation.param("value", shortDescription);
        descriptionAnnotation.param("verbose", verboseDescription);
    }

    private void addVersionAnnotations(JDefinedClass jDefinedClass, int major, int minor, int patch) {
        JAnnotationUse versionAnnotation = jDefinedClass.annotate(Version.class);
        versionAnnotation.param("major", major);
        versionAnnotation.param("minor", minor);
        versionAnnotation.param("patch", patch);
    }

    private void addExtends(JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        jDefinedClass._extends(jCodeModel.ref(ServiceClient.class));
    }

    private void addInterfaceFields(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        if (serviceIdl.getService().getObjectMapperClass() != null) {
            int fieldModifier = 9;
            JClass objectMapper = jCodeModel.ref(serviceIdl.getService().getObjectMapperClass());
            jDefinedClass.field(fieldModifier, (JType)objectMapper, "customObjectMapper", (JExpression)JExpr._new((JClass)objectMapper));
        }
    }

    private void addExtendsImplements(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        jDefinedClass._extends(jCodeModel.ref(AbstractServiceClient.class));
        jDefinedClass._implements(jCodeModel.ref(this.getInterfaceName(serviceIdl)));
    }

    private void addConstructor(ServiceIDL serviceIdl, JDefinedClass jDefinedClass) {
        JFieldRef arg2;
        JMethod constructor = jDefinedClass.constructor(4);
        JBlock block = constructor.body();
        if (serviceIdl.getExceptions() != null && serviceIdl.getExceptions().size() > 0) {
            for (Integer serviceResponseCode : serviceIdl.getExceptions().keySet()) {
                arg2 = JExpr.ref((JExpression)JExpr.ref((String)(serviceIdl.getExceptions().get(serviceResponseCode) + "Exception")), (String)"class");
                block.invoke((JExpression)JExpr.ref((String)"exceptions"), "put").arg(serviceResponseCode.toString()).arg((JExpression)arg2);
            }
        }
        arg2 = JExpr.ref((JExpression)JExpr.ref((String)(serviceIdl.getService().getName() + "Exception")), (String)"class");
        block.invoke((JExpression)JExpr.ref((String)"exceptions"), "put").arg("default").arg((JExpression)arg2);
    }

    private void addMethods(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass, boolean isImpl) {
        for (Map.Entry<String, EndPoint> entry : serviceIdl.getEndPoints().entrySet()) {
            String methodName = entry.getKey();
            EndPoint endPoint = entry.getValue();
            JType methodReturnType = this.getJType(jCodeModel, endPoint.getResponseObject());
            JClass methodFullReturnType = jCodeModel.ref(FutureTaskResultToDomainObjectPromiseWrapper.class).narrow(methodReturnType);
            JMethod method = jDefinedClass.method(1, (JType)methodFullReturnType, methodName);
            if (isImpl) {
                method.annotate(jCodeModel.ref("Override"));
            }
            JDocComment methodComment = method.javadoc();
            methodComment.addAll(Arrays.asList(endPoint.getDescription()));
            String[] parameters = endPoint.getParameters();
            if (parameters == null) {
                parameters = new String[]{};
            }
            for (String paramName : parameters) {
                this.generateMethodParam(serviceIdl, jCodeModel, method, methodComment, paramName);
            }
            if (endPoint.isIncludeMetaInfo()) {
                this.generateMethodParam(serviceIdl, jCodeModel, method, methodComment, META_INFO_PARAMETER_NAME);
            }
            Map<String, String> headersMap = this.getAllHeaders(serviceIdl, endPoint);
            for (Map.Entry<String, String> headerMapEntry : headersMap.entrySet()) {
                String value = headerMapEntry.getValue();
                Matcher matcher = PARAMETERS_PATTERN.matcher(value);
                if (!matcher.find()) continue;
                String paramName = matcher.group(1);
                this.generateMethodParam(serviceIdl, jCodeModel, method, methodComment, paramName);
            }
            if (endPoint.getRequestObject() != null) {
                method.param(this.getJType(jCodeModel, endPoint.getRequestObject()), REQUEST_OBJECT_VAR_NAME);
                methodComment.addParam(REQUEST_OBJECT_VAR_NAME);
            }
            if (endPoint.getResponseObject() != null && !endPoint.getResponseObject().isEmpty()) {
                JCommentPart returnComment = methodComment.addReturn();
                returnComment.append((Object)methodFullReturnType);
            }
            method._throws(jCodeModel.directClass("Exception"));
            if (!isImpl) continue;
            this.addMethodBody(serviceIdl, jCodeModel, endPoint, method.body());
        }
    }

    private void addMethodBody(ServiceIDL serviceIdl, JCodeModel jCodeModel, EndPoint endPoint, JBlock block) {
        if (endPoint.getRequestSplitterClass() != null) {
            JClass requestSplitter = jCodeModel.ref(endPoint.getRequestSplitterClass());
            block.decl((JType)requestSplitter, "requestSplitter", (JExpression)JExpr._new((JClass)requestSplitter));
            JClass responseMerger = jCodeModel.ref(endPoint.getResponseMergerClass());
            block.decl((JType)responseMerger, "responseMerger", (JExpression)JExpr._new((JClass)responseMerger));
            JClass wrapper = jCodeModel.ref(FutureTaskResultToDomainObjectPromiseWrapper.class);
            block.decl((JType)wrapper, "wrapper", (JExpression)JExpr._new((JClass)wrapper).arg((JExpression)JExpr.ref((String)"responseMerger")));
            if (endPoint.getRequestParamWithLimit() != null) {
                Matcher matcher = PARAMETERS_PATTERN.matcher(endPoint.getRequestParamWithLimit());
                if (matcher.matches()) {
                    Parameter parameter = serviceIdl.getParameters().get(matcher.group(1));
                    JClass listClass = jCodeModel.ref(parameter.getType());
                    String listClassVar = matcher.group(1) + "List";
                    String listElement = listClassVar + "Element";
                    block.decl((JType)jCodeModel.ref(List.class).narrow(listClass), listClassVar, (JExpression)JExpr.ref((String)"requestSplitter").invoke("split").arg((JExpression)JExpr.ref((String)matcher.group(1))));
                    JForEach forEach = new JForEach((JType)listClass, listElement, (JExpression)JExpr.ref((String)listClassVar));
                    JInvocation invocation = this.createRequest(serviceIdl, jCodeModel, endPoint, forEach.body(), matcher.group(1), listElement);
                    forEach.body().add((JStatement)JExpr.ref((String)"wrapper").invoke("addFutureForTask").arg((JExpression)invocation.invoke("getFutureList")));
                    block.add((JStatement)forEach);
                    block._return((JExpression)JExpr.ref((String)"wrapper"));
                    return;
                }
            } else if (endPoint.getRequestSplitterClass() != null) {
                JInvocation invocation = this.createRequest(serviceIdl, jCodeModel, endPoint, block, null, null);
                JClass returnType = jCodeModel.ref(List.class).narrow(this.getJType(jCodeModel, endPoint.getRequestObject()));
                block.decl((JType)returnType, "requestObjects", (JExpression)JExpr.ref((String)"requestSplitter").invoke("split").arg((JExpression)JExpr.ref((String)REQUEST_OBJECT_VAR_NAME)));
                JForEach forEach = new JForEach(this.getJType(jCodeModel, endPoint.getRequestObject()), REQUEST_OBJECT_LOOP_VAR_NAME, (JExpression)JExpr.ref((String)"requestObjects"));
                forEach.body().add((JStatement)JExpr.ref((String)"wrapper").invoke("addFutureForTask").arg((JExpression)invocation.invoke("getFutureList")));
                block.add((JStatement)forEach);
                block._return((JExpression)JExpr.ref((String)"wrapper"));
                return;
            }
        }
        JInvocation invocation = this.createRequest(serviceIdl, jCodeModel, endPoint, block, null, null);
        block._return((JExpression)invocation);
    }

    /*
     * WARNING - void declaration
     */
    private JInvocation createRequest(ServiceIDL serviceIdl, JCodeModel jCodeModel, EndPoint endPoint, JBlock block, String requestParamWithLimit, String listElementVarName) {
        Map<String, String> headersMap;
        Object parameter;
        JInvocation invocation;
        String baseUri = serviceIdl.getService().getBaseUri();
        String endPointUri = endPoint.getUri();
        String uri = (baseUri + endPointUri).replaceAll("//", "/");
        LinkedHashSet<String> argsList = new LinkedHashSet<String>();
        LinkedHashSet<JInvocation> argsListQueryParams = new LinkedHashSet<JInvocation>();
        Matcher matcher = PARAMETERS_PATTERN.matcher(uri);
        while (matcher.find()) {
            uri = matcher.replaceFirst("%s");
            argsList.add(matcher.group(1));
            matcher.reset(uri);
        }
        if (argsList.isEmpty()) {
            block.decl((JType)jCodeModel.ref("String"), "uri", JExpr.lit((String)uri));
        } else {
            invocation = JExpr.ref((String)"String").invoke("format").arg(uri);
            for (String string : argsList) {
                void var15_16;
                parameter = serviceIdl.getParameters().get(string);
                if (endPoint.getRequestParamWithLimit() != null && requestParamWithLimit.equals(string)) {
                    String string2 = listElementVarName;
                }
                if (((Parameter)parameter).getType().equals("String")) {
                    invocation.arg((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)JExpr.ref((String)var15_16)));
                    continue;
                }
                if (((Parameter)parameter).getType().endsWith("[]")) {
                    JInvocation jInvocation = jCodeModel.ref(Joiner.class).staticInvoke("on").arg(JExpr.lit((char)',')).invoke("join").arg((JExpression)JExpr.ref((String)var15_16));
                    invocation.arg((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)jInvocation));
                    continue;
                }
                if (((Parameter)parameter).getType().startsWith("java.util.List")) {
                    invocation.arg((JExpression)jCodeModel.ref(StringUtils.class).staticInvoke("join").arg((JExpression)JExpr.ref((String)var15_16)).arg(","));
                    continue;
                }
                invocation.arg((JExpression)JExpr.ref((String)var15_16));
            }
            block.decl((JType)jCodeModel.ref("String"), "uri", (JExpression)invocation);
        }
        if (endPoint.getParameters() != null) {
            void var15_20;
            invocation = endPoint.getParameters();
            int n = ((String[])invocation).length;
            boolean bl = false;
            while (var15_20 < n) {
                JInvocation paramName = invocation[var15_20];
                Parameter parameter2 = serviceIdl.getParameters().get(paramName);
                if (!parameter2.getOptional().booleanValue()) {
                    if (parameter2.getType().equalsIgnoreCase("string") || parameter2.getType().endsWith("[]")) {
                        block.add((JStatement)jCodeModel.ref(Validate.class).staticInvoke("notEmpty").arg((JExpression)JExpr.ref((String)paramName)).arg((String)paramName + " can not be null/empty"));
                    } else {
                        block.add((JStatement)jCodeModel.ref(Validate.class).staticInvoke("notNull").arg((JExpression)JExpr.ref((String)paramName)).arg((String)paramName + " can not be null"));
                    }
                }
                if (!argsList.contains(paramName)) {
                    argsListQueryParams.add(paramName);
                }
                ++var15_20;
            }
        }
        if (endPoint.isIncludeMetaInfo() && endPoint.getMetaInfo() != null && endPoint.getMetaInfo().isDynamicCommandName()) {
            invocation = jCodeModel.ref("String").staticInvoke("valueOf").arg((JExpression)JExpr.ref((String)META_INFO_PARAMETER_NAME).invoke("get").arg("commandName"));
            block.decl((JType)jCodeModel.ref("String"), META_INFO_COMMAND_NAME_VAR_NAME, (JExpression)invocation);
            block.add((JStatement)jCodeModel.ref(Validate.class).staticInvoke("notNull").arg((JExpression)JExpr.ref((String)META_INFO_COMMAND_NAME_VAR_NAME)).arg("_metaInfoCommandName can not be null"));
        }
        if (!argsListQueryParams.isEmpty()) {
            invocation = jCodeModel.ref(Arrays.class).staticInvoke("asList");
            for (String string : argsListQueryParams) {
                void var17_31;
                parameter = serviceIdl.getParameters().get(string);
                String string3 = string;
                if (endPoint.getRequestParamWithLimit() != null && requestParamWithLimit.equals(string)) {
                    String string4 = listElementVarName;
                }
                String paramName = Optional.ofNullable(((Parameter)parameter).getName()).orElse(string);
                if (!((Parameter)parameter).getOptional().booleanValue()) {
                    JInvocation joinerExpression;
                    if (((Parameter)parameter).isMultiValue()) {
                        invocation.arg((JExpression)JExpr.invoke((String)"getMultiValueParamURI").arg(paramName).arg((JExpression)JExpr.ref((String)var17_31)));
                        continue;
                    }
                    if (((Parameter)parameter).getType().equals("String")) {
                        invocation.arg(JExpr.lit((String)(paramName + "=")).plus((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)JExpr.ref((String)var17_31))));
                        continue;
                    }
                    if (((Parameter)parameter).getType().endsWith("[]")) {
                        joinerExpression = jCodeModel.ref(Joiner.class).staticInvoke("on").arg(JExpr.lit((char)',')).invoke("join").arg((JExpression)JExpr.ref((String)var17_31));
                        invocation.arg(JExpr.lit((String)(paramName + "=")).plus((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)joinerExpression)));
                        continue;
                    }
                    if (((Parameter)parameter).getType().startsWith("java.util.List")) {
                        joinerExpression = jCodeModel.ref(StringUtils.class).staticInvoke("join").arg((JExpression)JExpr.ref((String)var17_31)).arg(",");
                        invocation.arg(JExpr.lit((String)(paramName + "=")).plus((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)joinerExpression)));
                        continue;
                    }
                    invocation.arg(JExpr.lit((String)(paramName + "=")).plus((JExpression)JExpr.ref((String)var17_31)));
                    continue;
                }
                if (((Parameter)parameter).isMultiValue()) {
                    invocation.arg((JExpression)JExpr.invoke((String)"getMultiValueParamURI").arg(paramName).arg((JExpression)JExpr.ref((String)var17_31)));
                    continue;
                }
                invocation.arg((JExpression)JExpr.invoke((String)"getOptURI").arg(paramName).arg((JExpression)JExpr.ref((String)var17_31)));
            }
            block.assign((JAssignmentTarget)JExpr.ref((String)"uri"), JExpr.ref((String)"uri").plus((JExpression)JExpr.invoke((String)"getQueryURI").arg((JExpression)invocation)));
        }
        if ((headersMap = this.getAllHeaders(serviceIdl, endPoint)).size() > 0) {
            JClass mapClass = jCodeModel.ref(Map.class).narrow(new JClass[]{jCodeModel.ref("String"), jCodeModel.ref("String")});
            JClass jClass = jCodeModel.ref(HashMap.class).narrow(new JClass[]{jCodeModel.ref("String"), jCodeModel.ref("String")});
            block.decl((JType)mapClass, "headersMap", (JExpression)JExpr._new((JClass)jClass));
            for (Map.Entry entry : headersMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                JInvocation invocation2 = JExpr.invoke((JExpression)JExpr.ref((String)"headersMap"), (String)"put").arg(key);
                matcher = PARAMETERS_PATTERN.matcher(value);
                if (matcher.find()) {
                    String paramName = matcher.group(1);
                    invocation2.arg((JExpression)jCodeModel.ref("String").staticInvoke("valueOf").arg((JExpression)JExpr.ref((String)paramName)));
                    Parameter parameter3 = serviceIdl.getParameters().get(paramName);
                    if (parameter3.getOptional().booleanValue()) {
                        block._if(JExpr.ref((String)paramName).ne(JExpr._null()))._then().add((JStatement)invocation2);
                        continue;
                    }
                    block.add((JStatement)invocation2);
                    continue;
                }
                invocation2.arg(value);
                block.add((JStatement)invocation2);
            }
        }
        if (endPoint.getResponseObject() != null && !endPoint.getResponseObject().isEmpty()) {
            void var17_51;
            void var17_46;
            void var17_40;
            JInvocation invocation3 = JExpr.invoke((String)"execute");
            JType jType = jCodeModel._ref(ServiceExecutePropertiesBuilder.class);
            JInvocation nestedInvocation = JExpr.invoke((String)"getJavaType");
            if (!endPoint.getResponseObject().contains("<")) {
                if (endPoint.getResponseObject().contains(".")) {
                    JInvocation jInvocation = jCodeModel.ref(Class.class).staticInvoke("forName").arg(endPoint.getResponseObject());
                    nestedInvocation.arg((JExpression)jInvocation);
                } else {
                    JFieldRef jFieldRef = JExpr.ref((JExpression)JExpr.ref((String)endPoint.getResponseObject()), (String)"class");
                    nestedInvocation.arg((JExpression)jFieldRef);
                }
            } else {
                JClass jClass = jCodeModel.ref(TypeReference.class).narrow(this.getJType(jCodeModel, endPoint.getResponseObject()));
                nestedInvocation.arg((JExpression)JExpr._new((JClass)jCodeModel.anonymousClass(jClass)));
            }
            JInvocation jInvocation = JExpr.invoke((JExpression)JExpr._new((JType)jType), (String)"setJavaType").arg((JExpression)nestedInvocation);
            if (endPoint.getErrorResponseObject() != null && !endPoint.getErrorResponseObject().isEmpty()) {
                JInvocation nestedErrorInvocation = JExpr.invoke((String)"getErrorType");
                if (!endPoint.getErrorResponseObject().contains("<")) {
                    if (endPoint.getErrorResponseObject().contains(".")) {
                        JInvocation classDecl = jCodeModel.ref(Class.class).staticInvoke("forName").arg(endPoint.getErrorResponseObject());
                        nestedErrorInvocation.arg((JExpression)classDecl);
                    } else {
                        JFieldRef ref = JExpr.ref((JExpression)JExpr.ref((String)endPoint.getErrorResponseObject()), (String)"class");
                        nestedErrorInvocation.arg((JExpression)ref);
                    }
                } else {
                    JClass typeReferenceClass = jCodeModel.ref(TypeReference.class).narrow(this.getJType(jCodeModel, endPoint.getErrorResponseObject()));
                    nestedErrorInvocation.arg((JExpression)JExpr._new((JClass)jCodeModel.anonymousClass(typeReferenceClass)));
                }
                JInvocation jInvocation2 = jInvocation.invoke("setErrorType").arg((JExpression)nestedErrorInvocation);
            }
            JInvocation jInvocation4 = var17_40.invoke("setUri").arg((JExpression)JExpr.ref((String)"uri"));
            jInvocation4 = jInvocation4.invoke("setHttpMethod").arg(endPoint.getHttpMethod());
            if (headersMap.size() > 0) {
                JInvocation jInvocation5 = jInvocation4.invoke("setHeadersMap").arg((JExpression)JExpr.ref((String)"headersMap"));
            }
            if (endPoint.getRequestObject() != null && !endPoint.getRequestObject().isEmpty()) {
                void var17_44;
                String requestObjectName = endPoint.getRequestSplitterClass() != null && endPoint.getRequestParamWithLimit() == null ? REQUEST_OBJECT_LOOP_VAR_NAME : REQUEST_OBJECT_VAR_NAME;
                JInvocation jInvocation6 = var17_44.invoke("setRequestObject").arg((JExpression)JExpr.ref((String)requestObjectName));
            }
            if (endPoint.isIncludeMetaInfo() && endPoint.getMetaInfo() != null && endPoint.getMetaInfo().isDynamicCommandName()) {
                JInvocation jInvocation7 = var17_46.invoke("setCommandName").arg((JExpression)JExpr.ref((String)META_INFO_COMMAND_NAME_VAR_NAME));
            } else if (endPoint.getCommandName() != null && !endPoint.getCommandName().isEmpty()) {
                JInvocation jInvocation8 = var17_46.invoke("setCommandName").arg(endPoint.getCommandName());
            }
            if (endPoint.isRequestCachingEnabled()) {
                void var17_49;
                JInvocation jInvocation9 = var17_49.invoke("setRequestCachingEnabled").arg(JExpr.lit((boolean)true));
            }
            JInvocation jInvocation10 = var17_51.invoke("build");
            return invocation3.arg((JExpression)jInvocation10);
        }
        return null;
    }

    private void addSimpleMethod(JCodeModel jCodeModel, JDefinedClass jDefinedClass, String methodName, String returnStr) {
        this.addSimpleMethod(jCodeModel, jDefinedClass, methodName, returnStr, null);
    }

    private void addSimpleMethod(JCodeModel jCodeModel, JDefinedClass jDefinedClass, String methodName, String returnStr, String exception) {
        JClass methodReturnType = jCodeModel.ref("String");
        JMethod method = jDefinedClass.method(1, (JType)methodReturnType, methodName);
        method.annotate(jCodeModel.ref("Override"));
        method.javadoc().addReturn().append((Object)methodReturnType);
        if (exception != null) {
            method._throws(jCodeModel.directClass(exception));
        }
        method.body()._return(JExpr.lit((String)returnStr));
    }

    private void addImplMethods(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        String commandName = serviceIdl.getService().getCommandName();
        if (commandName == null || commandName.isEmpty()) {
            commandName = Introspector.decapitalize(serviceIdl.getService().getName() + "HttpRequest");
        }
        this.addSimpleMethod(jCodeModel, jDefinedClass, "getCommandName", commandName);
        if (serviceIdl.getService().getObjectMapperClass() != null) {
            JClass methodReturnType = jCodeModel.ref(ObjectMapper.class);
            JMethod method = jDefinedClass.method(2, (JType)methodReturnType, "getObjectMapper");
            method.annotate(jCodeModel.ref("Override"));
            method.javadoc().addReturn().append((Object)methodReturnType);
            method.body()._return((JExpression)JExpr.ref((String)"customObjectMapper").invoke("getObjectMapper"));
        }
    }

    public void generateInterface(ServiceIDL serviceIdl, JCodeModel jCodeModel, String destinationFolder) throws Exception {
        JDefinedClass serviceInterface = jCodeModel._class(this.getFullInterfaceName(serviceIdl), ClassType.INTERFACE);
        this.addClassComments(serviceIdl, serviceInterface);
        this.addAnnotations(jCodeModel, serviceInterface);
        this.addExtends(jCodeModel, serviceInterface);
        this.addInterfaceFields(serviceIdl, jCodeModel, serviceInterface);
        this.addMethods(serviceIdl, jCodeModel, serviceInterface, false);
        jCodeModel.build(new File(destinationFolder), (PrintStream)null);
    }

    public void generateImpl(ServiceIDL serviceIdl, JCodeModel jCodeModel, String destinationFolder) throws Exception {
        JDefinedClass serviceImpl = jCodeModel._class(this.getFullImplName(serviceIdl), ClassType.CLASS);
        this.addClassComments(serviceIdl, serviceImpl);
        this.addAnnotations(jCodeModel, serviceImpl);
        this.addExtendsImplements(serviceIdl, jCodeModel, serviceImpl);
        this.addConstructor(serviceIdl, serviceImpl);
        this.addMethods(serviceIdl, jCodeModel, serviceImpl, true);
        this.addImplMethods(serviceIdl, jCodeModel, serviceImpl);
        this.addMetaAnnotations(serviceIdl, jCodeModel, serviceImpl);
        jCodeModel.build(new File(destinationFolder), (PrintStream)null);
    }

    private void addMetaAnnotations(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass serviceImpl) {
        String serviceName = CallableNameHelper.canonicalName((String)this.getInterfaceName(serviceIdl), (String)"ServiceClient", (String)"SC");
        this.addNameAnnotations(serviceImpl, serviceName);
        this.addVersionAnnotations(serviceImpl, serviceIdl.getVersion().getMajor(), serviceIdl.getVersion().getMinor(), serviceIdl.getVersion().getPatch());
        CharSequence[] description = serviceIdl.getService().getDescription();
        String shortDescription = description.length > 0 ? description[0] : this.getInterfaceName(serviceIdl);
        String fullDescription = description.length > 0 ? String.join((CharSequence)" ", description) : this.getInterfaceName(serviceIdl);
        this.addDescriptionAnnotations(serviceImpl, shortDescription, fullDescription);
    }
}

