/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.generator;

import com.flipkart.poseidon.serviceclients.generator.ExceptionGenerator;
import com.flipkart.poseidon.serviceclients.generator.JsonValidator;
import com.flipkart.poseidon.serviceclients.generator.PojoGenerator;
import com.flipkart.poseidon.serviceclients.generator.ServiceGenerator;
import com.flipkart.poseidon.serviceclients.generator.Versioner;
import com.flipkart.poseidon.serviceclients.idl.pojo.ServiceIDL;
import com.flipkart.poseidon.serviceclients.idl.pojo.Version;
import com.flipkart.poseidon.serviceclients.idl.reader.IDLReader;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final String IDL_BASE_PATH = ".src.main.resources.idl.";
    private static final String POJO_FOLDER_NAME = "pojos";
    private static final String SERVICE_FOLDER_NAME = "service";
    private static final String DESTINATION_JAVA_FOLDER = ".target.generated-sources.";
    private static final String PACKAGE_NAME = "com.flipkart.poseidon.serviceclients.";
    private static final JCodeModel jCodeModel = new JCodeModel();
    private static final Logger logger = LoggerFactory.getLogger(Generator.class);
    private static String moduleParentPath;
    private static String modulePath;
    private static String moduleName;
    private static Version version;
    private static String packageName;
    private static String[] pojoOrdering;

    public static void main(String[] args) throws Exception {
        if (!Generator.validateInput(args)) {
            Generator.printUsage();
            System.exit(-1);
        }
        logger.info("Using module parent path: {}", (Object)moduleParentPath);
        logger.info("Using module path: {}", (Object)modulePath);
        logger.info("Using module name: {}", (Object)moduleName);
        logger.info("Using version: {}", (Object)version);
        if (pojoOrdering != null && pojoOrdering.length > 0) {
            logger.info("Using pojo ordering: {}", (Object)Arrays.toString(pojoOrdering));
        }
        Generator.ensurePaths();
        Generator.generate();
    }

    private static boolean validateInput(String[] args) {
        if (args.length < 2) {
            return false;
        }
        int lastIndex = args[0].lastIndexOf(File.separatorChar);
        if (lastIndex <= 0) {
            logger.error("Invalid module path");
            return false;
        }
        modulePath = args[0];
        moduleName = modulePath.substring(lastIndex + 1);
        if (!moduleName.matches("^[a-zA-Z_]*$")) {
            logger.error("Invalid module name. Should contain only alphabets and underscore");
            return false;
        }
        moduleParentPath = modulePath.substring(0, lastIndex);
        Generator.determineVersion(args[1]);
        String majorVersion = "v" + version.getMajor();
        packageName = PACKAGE_NAME + moduleName + "." + majorVersion;
        if (args.length > 2) {
            pojoOrdering = args[2].split(",");
        }
        return true;
    }

    private static void determineVersion(String localPomVersion) {
        Generator.setVersion(localPomVersion);
    }

    private static void setVersion(String moduleVersion) {
        moduleVersion = moduleVersion.trim();
        String[] versions = moduleVersion.replace("-SNAPSHOT", "").split("\\.");
        version = new Version();
        for (int i = 0; i < versions.length; ++i) {
            int number;
            try {
                number = Integer.parseInt(versions[i]);
            }
            catch (NumberFormatException e) {
                number = 0;
            }
            if (i == 0) {
                version.setMajor(number);
                continue;
            }
            if (i == 1) {
                version.setMinor(number);
                continue;
            }
            if (i != 2) continue;
            version.setPatch(number);
        }
    }

    private static void updateVersion() {
        File[] files;
        String idlBasePath = IDL_BASE_PATH.replace('.', File.separatorChar);
        File folder = new File(modulePath + idlBasePath + SERVICE_FOLDER_NAME);
        if (folder.exists() && (files = folder.listFiles()) != null && files.length > 0) {
            Versioner.getInstance().updateVersion(moduleParentPath, moduleName, files[0].getPath(), version);
        }
    }

    private static void printUsage() {
        logger.error("Module path and version are required. Pojo files ordering is optional");
        logger.error("IntelliJ IDEA Ex: $MODULE_DIR$ 1.0.0-SNAPSHOT pojo1.json,pojo2.json");
        logger.error("Maven Ex: ${project.basedir} ${project.version} pojo1.json,pojo2.json");
    }

    private static void ensurePaths() {
        File javaFolder = new File(modulePath + DESTINATION_JAVA_FOLDER.replace('.', File.separatorChar));
        if (!javaFolder.exists() && !javaFolder.mkdirs()) {
            logger.warn("Couldn't create destination java folder");
        }
    }

    private static void generate() throws Exception {
        String idlBasePath = IDL_BASE_PATH.replace('.', File.separatorChar);
        File pojoFolder = new File(modulePath + idlBasePath + POJO_FOLDER_NAME);
        Generator.generatePojo(pojoFolder);
        File serviceFolder = new File(modulePath + idlBasePath + SERVICE_FOLDER_NAME);
        Generator.generateService(serviceFolder);
    }

    private static void generatePojo(File pojoFolder) throws Exception {
        File[] files;
        if (!pojoFolder.exists()) {
            return;
        }
        if (pojoOrdering != null && pojoOrdering.length > 0) {
            files = new File[pojoOrdering.length];
            int i = 0;
            String[] stringArray = pojoOrdering;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String fileName = stringArray[j];
                File file = new File(pojoFolder.getPath() + File.separator + fileName);
                if (file.isDirectory()) {
                    throw new IllegalArgumentException("Pojo ordering can't contain a directory");
                }
                files[i++] = file;
            }
        } else {
            files = pojoFolder.listFiles();
        }
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Generator.generatePojo(file);
                continue;
            }
            logger.info("Generating from " + file.getName());
            String className = file.getName().replaceFirst("[.][^.]+$", "");
            Generator.generatePojo(className, file.getPath());
        }
    }

    private static void generateService(File serviceFolder) throws Exception {
        if (!serviceFolder.exists()) {
            return;
        }
        File[] files = serviceFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            logger.info("Generating from " + file.getName());
            String className = file.getName().replaceFirst("[.][^.]+$", "");
            Generator.generateService(className, file.getPath());
        }
    }

    private static void generatePojo(String className, String filePath) throws Exception {
        JsonValidator.getInstance().validatePojo(filePath);
        String pojoJson = FileUtils.readFileToString((File)new File(filePath));
        pojoJson = pojoJson.replaceAll("\"javaType\"\\s*:\\s*\"(?!.*\\.)", "\"javaType\": \"" + packageName + ".");
        String destinationFolder = modulePath + DESTINATION_JAVA_FOLDER.replace('.', File.separatorChar);
        PojoGenerator.getInstance().generate(pojoJson, jCodeModel, destinationFolder, className, packageName);
    }

    private static void generateService(String className, String filePath) throws Exception {
        JsonValidator.getInstance().validateService(filePath);
        ServiceIDL serviceIdl = IDLReader.getIDL(filePath);
        if (!className.endsWith("Service")) {
            className = className + "Service";
        }
        serviceIdl.getService().setName(className);
        serviceIdl.getService().setPackageName(packageName);
        serviceIdl.setVersion(version);
        serviceIdl.setExplicit(true);
        String destinationFolder = modulePath + DESTINATION_JAVA_FOLDER.replace('.', File.separatorChar);
        ServiceGenerator.getInstance().generateMetaInfo(serviceIdl);
        ServiceGenerator.getInstance().generateInterface(serviceIdl, jCodeModel, destinationFolder);
        ServiceGenerator.getInstance().generateImpl(serviceIdl, jCodeModel, destinationFolder);
        String exceptionClassName = packageName + "." + serviceIdl.getService().getName() + "Exception";
        ExceptionGenerator.getInstance().addExceptionClass(destinationFolder, exceptionClassName);
        if (serviceIdl.getExceptions() != null && serviceIdl.getExceptions().size() > 0) {
            for (int response : serviceIdl.getExceptions().keySet()) {
                exceptionClassName = packageName + "." + serviceIdl.getExceptions().get(response) + "Exception";
                ExceptionGenerator.getInstance().addExceptionClass(destinationFolder, exceptionClassName);
            }
        }
    }
}

