/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.flipkart.poseidon.serviceclients.ServiceContextState;
import com.flipkart.poseidon.serviceclients.ServiceDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ServiceContext {
    private static final ThreadLocal<Map<String, Object>> context = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static final ThreadLocal<Boolean> isImmutable = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final ThreadLocal<Boolean> isDebug = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Map<String, List<ServiceDebug>>> debugResponses = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static final ThreadLocal<Map<String, Queue<String>>> collectedHeaders = ThreadLocal.withInitial(HashMap::new);

    public static void initialize(List<String> responseHeadersToCollect) {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.remove();
        isImmutable.set(false);
        if (responseHeadersToCollect == null || responseHeadersToCollect.isEmpty()) {
            return;
        }
        responseHeadersToCollect.forEach(header -> collectedHeaders.get().put(header.toLowerCase(), new ConcurrentLinkedQueue()));
    }

    public static void initialize(ServiceContextState state) {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.remove();
        context.get().putAll(state.ctxt);
        if (state.debug) {
            isDebug.set(state.debug);
            debugResponses.remove();
            debugResponses.set(state.serviceResponses);
        }
        collectedHeaders.remove();
        collectedHeaders.set(state.collectedHeaders);
        isImmutable.set(false);
    }

    public static void set(String key, Object value) {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.get().put(key, value);
    }

    public static void enableDebug() {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        isDebug.set(true);
    }

    public static void disableDebug() {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        isDebug.set(false);
    }

    public static boolean isDebug() {
        return isDebug.get();
    }

    public static void addDebugResponse(String key, ServiceDebug response) {
        if (!ServiceContext.isDebug()) {
            return;
        }
        debugResponses.get().computeIfAbsent(key, k -> new ArrayList()).add(response);
    }

    public static Map<String, List<ServiceDebug>> getDebugResponses() {
        return debugResponses.get();
    }

    public static <T> T get(String key) {
        return (T)context.get().get(key);
    }

    public static Map<String, Object> getContextMap() {
        return new HashMap<String, Object>(context.get());
    }

    public static void shutDown() {
        context.remove();
        isImmutable.remove();
        isDebug.remove();
        debugResponses.remove();
    }

    static Map<String, Queue<String>> getCollectedHeaders() {
        return collectedHeaders.get();
    }

    public static List<String> getCollectedHeaders(String header) {
        return Optional.ofNullable(ServiceContext.getCollectedHeaders()).map(m -> (Queue)m.get(header.toLowerCase())).map(ArrayList::new).orElseGet(null);
    }

    public static ServiceContextState getState() {
        ServiceContextState state = new ServiceContextState();
        state.ctxt = ServiceContext.getContextMap();
        state.collectedHeaders = ServiceContext.getCollectedHeaders();
        state.debug = ServiceContext.isDebug();
        state.serviceResponses = ServiceContext.getDebugResponses();
        return state;
    }
}

