/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.poseidon.handlers.http.HttpResponseDecoder;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.serviceclients.ServiceClientException;
import com.flipkart.poseidon.serviceclients.ServiceResponse;
import com.flipkart.poseidon.serviceclients.ServiceResponseInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;

public class ServiceResponseDecoder<T>
implements HttpResponseDecoder<ServiceResponse<T>> {
    private final ObjectMapper objectMapper;
    private final Logger logger;
    private final Map<String, ServiceResponseInfo> serviceResponseInfoMap = new HashMap<String, ServiceResponseInfo>();
    private final Map<String, Queue<String>> collectedHeaders;
    private final Map<String, List<String>> localCollectedHeaders = new HashMap<String, List<String>>();

    @Deprecated
    public ServiceResponseDecoder(ObjectMapper objectMapper, JavaType javaType, JavaType errorType, Logger logger, Map<String, Class<? extends ServiceClientException>> exceptions) {
        this(objectMapper, javaType, errorType, logger, exceptions, Collections.emptyMap());
    }

    @Deprecated
    public ServiceResponseDecoder(ObjectMapper objectMapper, JavaType javaType, JavaType errorType, Logger logger, Map<String, Class<? extends ServiceClientException>> exceptions, Map<String, Queue<String>> collectedHeaders) {
        this(objectMapper, logger, new HashMap<String, ServiceResponseInfo>(), collectedHeaders);
        this.serviceResponseInfoMap.put("200", new ServiceResponseInfo(javaType, null));
        exceptions.forEach((s, c) -> this.serviceResponseInfoMap.put((String)s, new ServiceResponseInfo(errorType, (Class<? extends ServiceClientException>)c)));
    }

    public ServiceResponseDecoder(ObjectMapper objectMapper, Logger logger, Map<String, ServiceResponseInfo> serviceResponseInfoMap, Map<String, Queue<String>> collectedHeaders) {
        this.objectMapper = objectMapper;
        this.logger = logger;
        this.serviceResponseInfoMap.putAll(serviceResponseInfoMap);
        this.collectedHeaders = collectedHeaders;
    }

    private Map<String, String> getHeaders(HttpResponse httpResponse) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Header[] responseHeaders = httpResponse.getAllHeaders();
        if (responseHeaders == null || responseHeaders.length == 0) {
            return headers;
        }
        for (Header header : responseHeaders) {
            String lowerCaseHeader;
            headers.put(header.getName(), header.getValue());
            if (this.collectedHeaders.isEmpty() || !this.collectedHeaders.containsKey(lowerCaseHeader = header.getName().toLowerCase())) continue;
            this.localCollectedHeaders.computeIfAbsent(lowerCaseHeader, s -> new ArrayList()).add(header.getValue());
        }
        return headers;
    }

    public ServiceResponse<T> decode(HttpResponse httpResponse) throws Exception {
        Map<String, String> headers = this.getHeaders(httpResponse);
        this.collectedHeaders.forEach((k, v) -> Optional.ofNullable(this.localCollectedHeaders.get(k)).ifPresent(v::addAll));
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String statusCodeString = String.valueOf(statusCode);
        if (statusCode >= 200 && statusCode <= 299) {
            if (statusCode == 204) {
                return new ServiceResponse<Object>(null, headers);
            }
            try {
                JavaType javaType = this.serviceResponseInfoMap.get("200").getType();
                if (String.class.isAssignableFrom(javaType.getRawClass())) {
                    return new ServiceResponse<String>(IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), headers);
                }
                return new ServiceResponse<Object>(this.objectMapper.readValue(httpResponse.getEntity().getContent(), javaType), headers);
            }
            catch (JsonMappingException e) {
                if (e.getMessage().contains("No content to map due to end-of-input")) {
                    return new ServiceResponse<Object>(null, headers);
                }
                this.logger.error("Error de-serializing response object exception: {}", (Object)e.getMessage());
                throw new IOException("Response object de-serialization error", e);
            }
            catch (Exception e) {
                this.logger.error("Error de-serializing response object exception: {}", (Object)e.getMessage());
                throw new IOException("Response object de-serialization error", e);
            }
        }
        String serviceResponse = StringUtils.convertStreamToString((InputStream)httpResponse.getEntity().getContent());
        Object errorResponse = null;
        ServiceResponseInfo responseInfo = Optional.ofNullable(this.serviceResponseInfoMap.get(statusCodeString)).orElseGet(() -> this.serviceResponseInfoMap.get("default"));
        JavaType errorType = responseInfo.getType();
        if (errorType != null) {
            try {
                errorResponse = this.objectMapper.readValue(serviceResponse, errorType);
            }
            catch (Exception e) {
                this.logger.warn("Error while de-serializing non 200 response to given errorType statusCode:{} exception: {}", (Object)statusCodeString, (Object)e.getMessage());
            }
        }
        Class<? extends ServiceClientException> exceptionClass = responseInfo.getExceptionClass();
        String exceptionMessage = statusCodeString + " " + serviceResponse;
        ServiceClientException serviceClientException = exceptionClass.getConstructor(String.class, Object.class).newInstance(exceptionMessage, errorResponse);
        if (statusCode >= 500 && statusCode <= 599) {
            this.logger.error("Non 200 response statusCode: {} response: {}", (Object)statusCodeString, (Object)serviceResponse);
            throw serviceClientException;
        }
        this.logger.debug("Non 200 response statusCode: {} response: {}", (Object)statusCodeString, (Object)serviceResponse);
        return new ServiceResponse(serviceClientException, headers);
    }

    public ServiceResponse<T> decode(String stringResponse) throws Exception {
        try {
            return new ServiceResponse<Object>(this.objectMapper.readValue(stringResponse, this.serviceResponseInfoMap.get("200").getType()), null);
        }
        catch (IOException e) {
            this.logger.error("Error de-serializing response object", (Throwable)e);
            throw new Exception("Response object de-serialization error", e);
        }
    }

    public ServiceResponse<T> decode(byte[] byteResponse) throws Exception {
        try {
            return new ServiceResponse<Object>(this.objectMapper.readValue(byteResponse, this.serviceResponseInfoMap.get("200").getType()), null);
        }
        catch (IOException e) {
            this.logger.error("Error de-serializing response object", (Throwable)e);
            throw new IOException("Response object de-serialization error", e);
        }
    }

    public ServiceResponse<T> decode(InputStream is) throws Exception {
        return new ServiceResponse<Object>(this.objectMapper.readValue(is, this.serviceResponseInfoMap.get("200").getType()), null);
    }
}

