/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.generator;

import com.flipkart.poseidon.serviceclients.executor.CommandFailedException;
import com.flipkart.poseidon.serviceclients.executor.GitCommandExecutor;
import com.flipkart.poseidon.serviceclients.executor.MavenCommandExecutor;
import com.flipkart.poseidon.serviceclients.idl.pojo.ServiceIDL;
import com.flipkart.poseidon.serviceclients.idl.pojo.Version;
import com.flipkart.poseidon.serviceclients.idl.reader.IDLReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Versioner {
    private static final Logger logger = LoggerFactory.getLogger(Versioner.class);
    private static final Versioner VERSIONER = new Versioner();

    private Versioner() {
    }

    public static Versioner getInstance() {
        return VERSIONER;
    }

    public void updateVersion(String moduleParentPath, String moduleName, String filePath, Version version) {
        try {
            String relativeFilePath = filePath.substring(filePath.lastIndexOf(moduleName));
            String json = GitCommandExecutor.getHeadVersion(moduleParentPath, relativeFilePath);
            ServiceIDL oldServiceIdl = IDLReader.convertToIDL(json);
            ServiceIDL newServiceIdl = IDLReader.getIDL(filePath);
            if (this.changeVersion(oldServiceIdl, newServiceIdl, moduleName, version)) {
                logger.info("Updating version as {} for {}", (Object)version, (Object)moduleName);
                MavenCommandExecutor.setVersion(moduleParentPath, moduleName, version);
            }
        }
        catch (CommandFailedException e) {
            logger.error("Command failed with exit code {}. Output {}", (Object)e.getExitCode(), (Object)e.getOutput());
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public boolean changeVersion(ServiceIDL oldServiceIdl, ServiceIDL newServiceIdl, String moduleName, Version version) {
        if (oldServiceIdl.equals(newServiceIdl)) {
            logger.info("No changes detected for {}", (Object)moduleName);
            return false;
        }
        if (!this.isBackwardCompatible(oldServiceIdl, newServiceIdl)) {
            logger.info("Bumping major version for {}", (Object)moduleName);
            version.setMajor(version.getMajor() + 1);
        } else {
            logger.info("Bumping minor version for {}", (Object)moduleName);
            version.setMinor(version.getMinor() + 1);
        }
        return true;
    }

    public boolean isBackwardCompatible(ServiceIDL oldServiceIdl, ServiceIDL newServiceIdl) {
        return oldServiceIdl.getEndPoints().size() == newServiceIdl.getEndPoints().size();
    }
}

