/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.poseidon.handlers.http.HttpResponseDecoder;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.serviceclients.ServiceClientException;
import com.flipkart.poseidon.serviceclients.ServiceResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;

public class ServiceResponseDecoder<T>
implements HttpResponseDecoder<ServiceResponse<T>> {
    private final ObjectMapper objectMapper;
    private final Class<T> clazz;
    private final Logger logger;
    private final Map<String, Class<? extends ServiceClientException>> exceptions;

    public ServiceResponseDecoder(ObjectMapper objectMapper, Class<T> clazz, Logger logger, Map<String, Class<? extends ServiceClientException>> exceptions) {
        this.objectMapper = objectMapper;
        this.clazz = clazz;
        this.logger = logger;
        this.exceptions = exceptions;
    }

    private Map<String, String> getHeaders(HttpResponse httpResponse) {
        HashMap<String, String> headers = new HashMap<String, String>();
        HeaderIterator iterator = httpResponse.headerIterator();
        if (iterator == null) {
            return headers;
        }
        while (iterator.hasNext()) {
            Header header = iterator.nextHeader();
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    public ServiceResponse<T> decode(HttpResponse httpResponse) throws Exception {
        Map<String, String> headers = this.getHeaders(httpResponse);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String statusCodeString = String.valueOf(statusCode);
        if (statusCode >= 200 && statusCode <= 299) {
            if (statusCode == 204) {
                return new ServiceResponse<Object>(null, headers);
            }
            try {
                if (String.class.isAssignableFrom(this.clazz)) {
                    return new ServiceResponse<String>(IOUtils.toString((InputStream)httpResponse.getEntity().getContent()), headers);
                }
                return new ServiceResponse<Object>(this.objectMapper.readValue(httpResponse.getEntity().getContent(), this.clazz), headers);
            }
            catch (JsonMappingException e) {
                if (e.getMessage().contains("No content to map due to end-of-input")) {
                    return new ServiceResponse<Object>(null, headers);
                }
                this.logger.error("Error de-serializing response object", (Throwable)e);
                throw new IOException("Response object de-serialization error", e);
            }
            catch (Exception e) {
                this.logger.error("Error de-serializing response object", (Throwable)e);
                throw new IOException("Response object de-serialization error", e);
            }
        }
        try {
            String serviceResponse = StringUtils.convertStreamToString((InputStream)httpResponse.getEntity().getContent());
            this.logger.warn("Non 200 response {}", (Object)serviceResponse);
            Class<? extends ServiceClientException> exceptionClass = this.exceptions.containsKey(statusCodeString) ? this.exceptions.get(statusCodeString) : this.exceptions.get("default");
            return new ServiceResponse(exceptionClass.getConstructor(String.class).newInstance(serviceResponse), headers);
        }
        catch (Exception e) {
            this.logger.error("Error de-serializing non 200 response", (Throwable)e);
            throw new IOException("Non 200 response de-serialization error", e);
        }
    }

    public ServiceResponse<T> decode(String stringResponse) throws Exception {
        try {
            return new ServiceResponse<Object>(this.objectMapper.readValue(stringResponse, this.clazz), null);
        }
        catch (IOException e) {
            this.logger.error("Error de-serializing response object", (Throwable)e);
            throw new Exception("Response object de-serialization error", e);
        }
    }

    public ServiceResponse<T> decode(byte[] byteResponse) throws Exception {
        try {
            return new ServiceResponse<Object>(this.objectMapper.readValue(byteResponse, this.clazz), null);
        }
        catch (IOException e) {
            this.logger.error("Error de-serializing response object", (Throwable)e);
            throw new IOException("Response object de-serialization error", e);
        }
    }

    public ServiceResponse<T> decode(InputStream is) {
        throw new UnsupportedOperationException();
    }
}

