/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.generator;

import com.flipkart.poseidon.serviceclients.AbstractServiceClient;
import com.flipkart.poseidon.serviceclients.CallableNameHelper;
import com.flipkart.poseidon.serviceclients.FutureTaskResultToDomainObjectPromiseWrapper;
import com.flipkart.poseidon.serviceclients.idl.pojo.EndPoint;
import com.flipkart.poseidon.serviceclients.idl.pojo.Parameter;
import com.flipkart.poseidon.serviceclients.idl.pojo.ServiceIDL;
import com.google.common.base.Joiner;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import flipkart.lego.api.entities.ServiceClient;
import java.beans.Introspector;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;

public class ServiceGenerator {
    private static final ServiceGenerator SERVICE_GENERATOR = new ServiceGenerator();
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("\\{parameters\\.(.*?)\\}");

    private ServiceGenerator() {
    }

    public static ServiceGenerator getInstance() {
        return SERVICE_GENERATOR;
    }

    private String getInterfaceName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getName() + "Client";
    }

    private String getFullInterfaceName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getPackageName() + "." + this.getInterfaceName(serviceIdl);
    }

    private String getImplName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getName() + "ClientImpl";
    }

    private String getFullImplName(ServiceIDL serviceIdl) {
        return serviceIdl.getService().getPackageName() + "." + this.getImplName(serviceIdl);
    }

    private JType getJType(JCodeModel jCodeModel, String name) {
        if (name == null || name.length() == 0) {
            name = "void";
        }
        try {
            return JType.parse((JCodeModel)jCodeModel, (String)name);
        }
        catch (IllegalArgumentException e) {
            return jCodeModel.directClass(name);
        }
    }

    private String getVariableName(String className) {
        return Introspector.decapitalize(className.replace("[", "").replace("]", ""));
    }

    private Map<String, String> getAllHeaders(ServiceIDL serviceIdl, EndPoint endPoint) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (serviceIdl.getService().getHeaders() != null) {
            headersMap.putAll(serviceIdl.getService().getHeaders());
        }
        if (endPoint.getHeaders() != null) {
            headersMap.putAll(endPoint.getHeaders());
        }
        return headersMap;
    }

    private void generateMethodParam(ServiceIDL serviceIdl, JCodeModel jCodeModel, JMethod method, JDocComment methodComment, String paramName) {
        Parameter parameter = serviceIdl.getParameters().get(paramName);
        JType jType = this.getJType(jCodeModel, parameter.getType());
        if (!parameter.getOptional().booleanValue()) {
            method.param((JType)jType.boxify(), paramName).annotate(NotNull.class);
        } else {
            method.param((JType)jType.boxify(), paramName);
        }
        JCommentPart paramComment = methodComment.addParam(paramName);
        if (parameter.getDescription() != null) {
            for (String description : parameter.getDescription()) {
                paramComment.append((Object)description);
            }
        }
    }

    private void addClassComments(ServiceIDL serviceIdl, JDefinedClass jDefinedClass) {
        JDocComment docComment = jDefinedClass.javadoc();
        docComment.addAll(Arrays.asList(serviceIdl.getService().getDescription()));
    }

    private void addAnnotations(JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        JAnnotationUse annotationUse = jDefinedClass.annotate(jCodeModel.ref("javax.annotation.Generated"));
        annotationUse.param("value", this.getClass().getName());
        annotationUse.param("date", new Date().toString());
        annotationUse.param("comments", "EDIT THIS IF YOU ARE ****");
    }

    private void addExtends(JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        jDefinedClass._extends(jCodeModel.ref(ServiceClient.class));
    }

    private void addInterfaceFields(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        int fieldModifier = 25;
        JFieldVar versionField = jDefinedClass.field(fieldModifier, (JType)jCodeModel.ref(List.class).narrow(Integer.class), "VERSION");
        JInvocation invocation = jCodeModel.ref(Arrays.class).staticInvoke("asList");
        invocation.arg(JExpr.lit((int)serviceIdl.getVersion().getMajor()));
        invocation.arg(JExpr.lit((int)serviceIdl.getVersion().getMinor()));
        invocation.arg(JExpr.lit((int)serviceIdl.getVersion().getPatch()));
        versionField.init((JExpression)invocation);
    }

    private void addExtendsImplements(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        jDefinedClass._extends(jCodeModel.ref(AbstractServiceClient.class));
        jDefinedClass._implements(jCodeModel.ref(this.getInterfaceName(serviceIdl)));
    }

    private void addConstructor(ServiceIDL serviceIdl, JDefinedClass jDefinedClass) {
        JFieldRef arg2;
        JMethod constructor = jDefinedClass.constructor(4);
        JBlock block = constructor.body();
        if (serviceIdl.getExceptions() != null && serviceIdl.getExceptions().size() > 0) {
            for (Integer serviceResponseCode : serviceIdl.getExceptions().keySet()) {
                arg2 = JExpr.ref((JExpression)JExpr.ref((String)(serviceIdl.getExceptions().get(serviceResponseCode) + "Exception")), (String)"class");
                block.invoke((JExpression)JExpr.ref((String)"exceptions"), "put").arg(serviceResponseCode.toString()).arg((JExpression)arg2);
            }
        }
        arg2 = JExpr.ref((JExpression)JExpr.ref((String)(serviceIdl.getService().getName() + "Exception")), (String)"class");
        block.invoke((JExpression)JExpr.ref((String)"exceptions"), "put").arg("default").arg((JExpression)arg2);
    }

    private void addMethods(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass, boolean isImpl) {
        for (Map.Entry<String, EndPoint> entry : serviceIdl.getEndPoints().entrySet()) {
            String methodName = entry.getKey();
            EndPoint endPoint = entry.getValue();
            JType methodReturnType = this.getJType(jCodeModel, endPoint.getResponseObject());
            JClass methodFullReturnType = jCodeModel.ref(FutureTaskResultToDomainObjectPromiseWrapper.class).narrow(methodReturnType);
            JMethod method = jDefinedClass.method(1, (JType)methodFullReturnType, methodName);
            if (isImpl) {
                method.annotate(jCodeModel.ref("Override"));
            }
            JDocComment methodComment = method.javadoc();
            methodComment.addAll(Arrays.asList(endPoint.getDescription()));
            String[] parameters = endPoint.getParameters();
            if (parameters == null) {
                parameters = new String[]{};
            }
            for (String paramName : parameters) {
                this.generateMethodParam(serviceIdl, jCodeModel, method, methodComment, paramName);
            }
            Map<String, String> headersMap = this.getAllHeaders(serviceIdl, endPoint);
            for (Map.Entry<String, String> headerMapEntry : headersMap.entrySet()) {
                String value = headerMapEntry.getValue();
                Matcher matcher = PARAMETERS_PATTERN.matcher(value);
                if (!matcher.find()) continue;
                String paramName = matcher.group(1);
                this.generateMethodParam(serviceIdl, jCodeModel, method, methodComment, paramName);
            }
            if (endPoint.getRequestObject() != null) {
                String paramName = this.getVariableName(endPoint.getRequestObject());
                method.param(this.getJType(jCodeModel, endPoint.getRequestObject()), paramName);
                methodComment.addParam(paramName);
            }
            if (endPoint.getResponseObject() != null && !endPoint.getResponseObject().isEmpty()) {
                JCommentPart returnComment = methodComment.addReturn();
                returnComment.append((Object)methodFullReturnType);
            }
            method._throws(jCodeModel.directClass("Exception"));
            if (!isImpl) continue;
            this.addMethodBody(serviceIdl, jCodeModel, endPoint, method.body());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addMethodBody(ServiceIDL serviceIdl, JCodeModel jCodeModel, EndPoint endPoint, JBlock block) {
        Map<String, String> headersMap;
        Object parameter;
        JInvocation invocation;
        String baseUri = serviceIdl.getService().getBaseUri();
        String endPointUri = endPoint.getUri();
        String uri = (baseUri + endPointUri).replaceAll("//", "/");
        LinkedHashSet<String> argsList = new LinkedHashSet<String>();
        LinkedHashSet<JInvocation> argsListQueryParams = new LinkedHashSet<JInvocation>();
        Matcher matcher = PARAMETERS_PATTERN.matcher(uri);
        while (matcher.find()) {
            uri = matcher.replaceFirst("%s");
            argsList.add(matcher.group(1));
            matcher.reset(uri);
        }
        if (argsList.isEmpty()) {
            block.decl((JType)jCodeModel.ref("String"), "uri", JExpr.lit((String)uri));
        } else {
            invocation = JExpr.ref((String)"String").invoke("format").arg(uri);
            for (String string : argsList) {
                parameter = serviceIdl.getParameters().get(string);
                if (((Parameter)parameter).getType().equals("String")) {
                    invocation.arg((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)JExpr.ref((String)string)));
                    continue;
                }
                if (((Parameter)parameter).getType().endsWith("[]")) {
                    JInvocation jInvocation = jCodeModel.ref(Joiner.class).staticInvoke("on").arg(JExpr.lit((char)',')).invoke("join").arg((JExpression)JExpr.ref((String)string));
                    invocation.arg((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)jInvocation));
                    continue;
                }
                invocation.arg((JExpression)JExpr.ref((String)string));
            }
            block.decl((JType)jCodeModel.ref("String"), "uri", (JExpression)invocation);
        }
        if (endPoint.getParameters() != null) {
            void var13_16;
            invocation = endPoint.getParameters();
            int n = ((String[])invocation).length;
            boolean bl = false;
            while (var13_16 < n) {
                JInvocation paramName = invocation[var13_16];
                Parameter parameter2 = serviceIdl.getParameters().get(paramName);
                if (!parameter2.getOptional().booleanValue()) {
                    if (parameter2.getType().equalsIgnoreCase("string") || parameter2.getType().endsWith("[]")) {
                        block.add((JStatement)jCodeModel.ref(Validate.class).staticInvoke("notEmpty").arg((JExpression)JExpr.ref((String)paramName)).arg((String)paramName + " can not be null/empty"));
                    } else {
                        block.add((JStatement)jCodeModel.ref(Validate.class).staticInvoke("notNull").arg((JExpression)JExpr.ref((String)paramName)).arg((String)paramName + " can not be null"));
                    }
                }
                if (!argsList.contains(paramName)) {
                    argsListQueryParams.add(paramName);
                }
                ++var13_16;
            }
        }
        if (!argsListQueryParams.isEmpty()) {
            invocation = jCodeModel.ref(Arrays.class).staticInvoke("asList");
            for (String string : argsListQueryParams) {
                parameter = serviceIdl.getParameters().get(string);
                if (!((Parameter)parameter).getOptional().booleanValue()) {
                    if (((Parameter)parameter).getType().equals("String")) {
                        invocation.arg(JExpr.lit((String)(string + "=")).plus((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)JExpr.ref((String)string))));
                        continue;
                    }
                    if (((Parameter)parameter).getType().endsWith("[]")) {
                        JInvocation jInvocation = jCodeModel.ref(Joiner.class).staticInvoke("on").arg(JExpr.lit((char)',')).invoke("join").arg((JExpression)JExpr.ref((String)string));
                        invocation.arg(JExpr.lit((String)(string + "=")).plus((JExpression)JExpr.invoke((String)"encodeUrl").arg((JExpression)jInvocation)));
                        continue;
                    }
                    invocation.arg(JExpr.lit((String)(string + "=")).plus((JExpression)JExpr.ref((String)string)));
                    continue;
                }
                invocation.arg((JExpression)JExpr.invoke((String)"getOptURI").arg(string).arg((JExpression)JExpr.ref((String)string)));
            }
            block.assign((JAssignmentTarget)JExpr.ref((String)"uri"), JExpr.ref((String)"uri").plus((JExpression)JExpr.invoke((String)"getQueryURI").arg((JExpression)invocation)));
        }
        if ((headersMap = this.getAllHeaders(serviceIdl, endPoint)).size() > 0) {
            JClass mapClass = jCodeModel.ref(Map.class).narrow(new JClass[]{jCodeModel.ref("String"), jCodeModel.ref("String")});
            JClass jClass = jCodeModel.ref(HashMap.class).narrow(new JClass[]{jCodeModel.ref("String"), jCodeModel.ref("String")});
            block.decl((JType)mapClass, "headersMap", (JExpression)JExpr._new((JClass)jClass));
            for (Map.Entry entry : headersMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                JInvocation invocation2 = block.invoke((JExpression)JExpr.ref((String)"headersMap"), "put").arg(key);
                matcher = PARAMETERS_PATTERN.matcher(value);
                boolean matchFound = false;
                if (matcher.find()) {
                    String paramName = matcher.group(1);
                    invocation2.arg((JExpression)jCodeModel.ref("String").staticInvoke("valueOf").arg((JExpression)JExpr.ref((String)paramName)));
                    matchFound = true;
                }
                if (matchFound) continue;
                invocation2.arg(value);
            }
        }
        if (endPoint.getResponseObject() != null && !endPoint.getResponseObject().isEmpty()) {
            void var13_21;
            JFieldRef ref = JExpr.ref((JExpression)JExpr.ref((String)endPoint.getResponseObject()), (String)"class");
            JInvocation jInvocation = JExpr.invoke((String)"execute").arg((JExpression)ref).arg((JExpression)JExpr.ref((String)"uri")).arg(endPoint.getHttpMethod());
            if (headersMap.size() > 0) {
                jInvocation.arg((JExpression)JExpr.ref((String)"headersMap"));
            } else {
                jInvocation.arg(JExpr._null());
            }
            if (endPoint.getRequestObject() != null && !endPoint.getRequestObject().isEmpty()) {
                String requestObjectName = this.getVariableName(endPoint.getRequestObject());
                jInvocation.arg((JExpression)JExpr.ref((String)requestObjectName));
            } else {
                jInvocation.arg(JExpr._null());
            }
            if (endPoint.getCommandName() != null && !endPoint.getCommandName().isEmpty()) {
                JInvocation jInvocation2 = jInvocation.arg(endPoint.getCommandName());
            }
            block._return((JExpression)var13_21);
        }
    }

    private void addSimpleMethod(JCodeModel jCodeModel, JDefinedClass jDefinedClass, String methodName, String returnStr) {
        this.addSimpleMethod(jCodeModel, jDefinedClass, methodName, returnStr, null);
    }

    private void addSimpleMethod(JCodeModel jCodeModel, JDefinedClass jDefinedClass, String methodName, String returnStr, String exception) {
        JClass methodReturnType = jCodeModel.ref("String");
        JMethod method = jDefinedClass.method(1, (JType)methodReturnType, methodName);
        method.annotate(jCodeModel.ref("Override"));
        method.javadoc().addReturn().append((Object)methodReturnType);
        if (exception != null) {
            method._throws(jCodeModel.directClass(exception));
        }
        method.body()._return(JExpr.lit((String)returnStr));
    }

    private void addImplMethods(ServiceIDL serviceIdl, JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        String commandName = serviceIdl.getService().getCommandName();
        if (commandName == null || commandName.isEmpty()) {
            commandName = Introspector.decapitalize(serviceIdl.getService().getName() + "HttpRequest");
        }
        this.addSimpleMethod(jCodeModel, jDefinedClass, "getCommandName", commandName);
        String serviceName = CallableNameHelper.canonicalName(this.getInterfaceName(serviceIdl), "ServiceClient", "SC");
        this.addSimpleMethod(jCodeModel, jDefinedClass, "getName", serviceName, "UnsupportedOperationException");
        JClass methodReturnType = jCodeModel.ref(List.class).narrow(Integer.class);
        JMethod method = jDefinedClass.method(1, (JType)methodReturnType, "getVersion");
        method.annotate(jCodeModel.ref("Override"));
        method.javadoc().addReturn().append((Object)methodReturnType);
        method._throws(jCodeModel.directClass("UnsupportedOperationException"));
        method.body()._return((JExpression)JExpr.ref((String)"VERSION"));
        CharSequence[] description = serviceIdl.getService().getDescription();
        String shortDescription = description.length > 0 ? description[0] : this.getInterfaceName(serviceIdl);
        this.addSimpleMethod(jCodeModel, jDefinedClass, "getShortDescription", shortDescription);
        String fullDescription = description.length > 0 ? String.join((CharSequence)" ", description) : this.getInterfaceName(serviceIdl);
        this.addSimpleMethod(jCodeModel, jDefinedClass, "getDescription", fullDescription);
    }

    public void generateInterface(ServiceIDL serviceIdl, JCodeModel jCodeModel, String destinationFolder) throws Exception {
        JDefinedClass serviceInterface = jCodeModel._class(this.getFullInterfaceName(serviceIdl), ClassType.INTERFACE);
        this.addClassComments(serviceIdl, serviceInterface);
        this.addAnnotations(jCodeModel, serviceInterface);
        this.addExtends(jCodeModel, serviceInterface);
        this.addInterfaceFields(serviceIdl, jCodeModel, serviceInterface);
        this.addMethods(serviceIdl, jCodeModel, serviceInterface, false);
        jCodeModel.build(new File(destinationFolder), (PrintStream)null);
    }

    public void generateImpl(ServiceIDL serviceIdl, JCodeModel jCodeModel, String destinationFolder) throws Exception {
        JDefinedClass serviceImpl = jCodeModel._class(this.getFullImplName(serviceIdl), ClassType.CLASS);
        this.addClassComments(serviceIdl, serviceImpl);
        this.addAnnotations(jCodeModel, serviceImpl);
        this.addExtendsImplements(serviceIdl, jCodeModel, serviceImpl);
        this.addConstructor(serviceIdl, serviceImpl);
        this.addMethods(serviceIdl, jCodeModel, serviceImpl, true);
        this.addImplMethods(serviceIdl, jCodeModel, serviceImpl);
        jCodeModel.build(new File(destinationFolder), (PrintStream)null);
    }
}

