/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.flipkart.phantom.task.spi.TaskResult;
import com.flipkart.poseidon.serviceclients.ServiceResponse;
import flipkart.lego.concurrency.api.Promise;
import flipkart.lego.concurrency.api.PromiseListener;
import flipkart.lego.concurrency.exceptions.PromiseBrokenException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureTaskResultToDomainObjectPromiseWrapper<DomainObject>
implements Promise<DomainObject> {
    private final Future<TaskResult> future;
    private final List<PromiseListener> promiseListeners = new ArrayList<PromiseListener>();
    private PromiseBrokenException promiseBrokenException;

    public FutureTaskResultToDomainObjectPromiseWrapper(Future<TaskResult> future) {
        this.future = future;
    }

    public boolean isRealized() {
        return this.future.isDone();
    }

    public boolean isFullfilled() throws IllegalStateException {
        return !this.future.isCancelled();
    }

    public boolean isBroken() throws IllegalStateException {
        return this.future.isCancelled();
    }

    public void await() throws InterruptedException {
        try {
            this.future.get();
            this.triggerListeners();
        }
        catch (ExecutionException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
        }
    }

    public void await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        try {
            this.future.get(timeout, timeUnit);
            this.triggerListeners();
        }
        catch (ExecutionException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public DomainObject get() throws PromiseBrokenException, InterruptedException {
        try {
            TaskResult taskResult = this.future.get();
            if (taskResult == null) {
                throw new PromiseBrokenException("Task result is null");
            }
            this.triggerListeners();
            ServiceResponse response = (ServiceResponse)taskResult.getData();
            if (!response.getIsSuccess()) {
                throw response.getException();
            }
            return (DomainObject)response.getData();
        }
        catch (ExecutionException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new PromiseBrokenException((Throwable)this.promiseBrokenException);
        }
    }

    public Map<String, String> getHeaders() throws PromiseBrokenException, InterruptedException {
        try {
            TaskResult taskResult = this.future.get();
            if (taskResult == null) {
                throw new PromiseBrokenException("Task result is null");
            }
            ServiceResponse response = (ServiceResponse)taskResult.getData();
            return response.getHeaders();
        }
        catch (ExecutionException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new PromiseBrokenException((Throwable)this.promiseBrokenException);
        }
    }

    public DomainObject get(long timeout, TimeUnit timeUnit) throws PromiseBrokenException, TimeoutException, InterruptedException {
        try {
            TaskResult taskResult = this.future.get(timeout, timeUnit);
            if (taskResult == null) {
                throw new PromiseBrokenException("Task result is null");
            }
            this.triggerListeners();
            ServiceResponse response = (ServiceResponse)taskResult.getData();
            if (!response.getIsSuccess()) {
                throw response.getException();
            }
            return (DomainObject)response.getData();
        }
        catch (ExecutionException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new PromiseBrokenException((Throwable)this.promiseBrokenException);
        }
    }

    public synchronized void addListener(PromiseListener promiseListener) {
        if (this.isRealized()) {
            this.triggerListener(promiseListener);
        } else {
            this.promiseListeners.add(promiseListener);
        }
    }

    private synchronized void triggerListeners() {
        for (PromiseListener promiseListener : this.promiseListeners) {
            this.triggerListener(promiseListener);
        }
    }

    private void triggerListener(PromiseListener promiseListener) {
        if (this.isFullfilled()) {
            try {
                promiseListener.whenFullfilled((Object)this.future.get());
            }
            catch (Exception exception) {}
        } else {
            promiseListener.whenBroken(this.promiseBrokenException);
        }
    }
}

