/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.log4j.message;

import com.flipkart.poseidon.log4j.message.AbstractAccessLog;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class AccessLog
extends AbstractAccessLog {
    public AccessLog(Request request, Response response) {
        this.populateRequestHeaders(request);
        this.remoteHost = this.ensureValue(request.getRemoteHost());
        this.populateRequestLine(request);
        this.statusCode = response.getStatus();
        this.contentLength = response.getContentCount();
        this.elapsedTime = this.timeStamp - request.getTimeStamp();
    }

    private void populateRequestHeaders(Request request) {
        this.requestHeaders = new HashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            this.requestHeaders.put(key.toLowerCase(), this.ensureValue(request.getHeader(key)));
        }
    }

    private void populateRequestLine(Request request) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ensureValue(request.getMethod())).append(' ').append(this.ensureValue(request.getRequestURI())).append(request.getQueryString() != null ? "?" + request.getQueryString() : "").append(' ').append(this.ensureValue(request.getProtocol()));
        this.requestLine = builder.toString();
    }
}

